/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.download;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;
import org.fusesource.fabric.agent.download.AbstractDownloadTask;
import org.fusesource.fabric.agent.download.DownloadFuture;
import org.fusesource.fabric.agent.download.FutureListener;
import org.fusesource.fabric.agent.download.MavenDownloadTask;
import org.fusesource.fabric.agent.download.SimpleDownloadTask;
import org.fusesource.fabric.agent.mvn.MavenConfiguration;
import org.fusesource.fabric.agent.mvn.MavenRepositoryURL;

public class DownloadManager {
    private ExecutorService executor;
    private final MavenConfiguration configuration;
    private final MavenRepositoryURL cache;
    private final MavenRepositoryURL system;

    public DownloadManager(MavenConfiguration configuration) throws MalformedURLException {
        this(configuration, null);
    }

    public DownloadManager(MavenConfiguration configuration, ExecutorService executor) throws MalformedURLException {
        this.configuration = configuration;
        this.executor = executor;
        this.cache = new MavenRepositoryURL("file://" + System.getProperty("karaf.data") + "/maven/agent" + "@snapshots");
        this.system = new MavenRepositoryURL("file://" + System.getProperty("karaf.home") + "/system" + "@snapshots");
    }

    public void shutdown() {
    }

    public DownloadFuture download(final String url) throws MalformedURLException {
        String mvnUrl = url;
        if (mvnUrl.startsWith("wrap:") && (mvnUrl = mvnUrl.substring("wrap:".length())).contains("$")) {
            mvnUrl = mvnUrl.substring(0, mvnUrl.lastIndexOf(36));
        }
        if (mvnUrl.startsWith("war:") && (mvnUrl = mvnUrl.substring("war:".length())).contains("?")) {
            mvnUrl = mvnUrl.substring(0, mvnUrl.lastIndexOf(63));
        }
        if (mvnUrl.startsWith("blueprint:") || mvnUrl.startsWith("spring:")) {
            mvnUrl = mvnUrl.substring(mvnUrl.indexOf(58) + 1);
        }
        if (mvnUrl.startsWith("mvn:")) {
            MavenDownloadTask task = new MavenDownloadTask(mvnUrl, this.cache, this.system, this.configuration, this.executor);
            this.executor.submit(task);
            if (!mvnUrl.equals(url)) {
                final DummyDownloadTask download = new DummyDownloadTask(url, this.executor);
                task.addListener(new FutureListener<DownloadFuture>(){

                    @Override
                    public void operationComplete(DownloadFuture future) {
                        try {
                            String mvn = future.getUrl();
                            String file = future.getFile().toURI().toURL().toString();
                            String real = url.replace(mvn, file);
                            SimpleDownloadTask task = new SimpleDownloadTask(real, DownloadManager.this.executor);
                            DownloadManager.this.executor.submit(task);
                            task.addListener(new FutureListener<DownloadFuture>(){

                                @Override
                                public void operationComplete(DownloadFuture future) {
                                    try {
                                        download.setFile(future.getFile());
                                    }
                                    catch (IOException e) {
                                        download.setException(e);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            download.setException(e);
                        }
                    }
                });
                return download;
            }
            return task;
        }
        SimpleDownloadTask download = new SimpleDownloadTask(url, this.executor);
        this.executor.submit(download);
        return download;
    }

    static class DummyDownloadTask
    extends AbstractDownloadTask {
        DummyDownloadTask(String url, ExecutorService executor) {
            super(url, executor);
        }

        @Override
        protected File download() throws Exception {
            return this.getFile();
        }
    }
}

