/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.maven.Maven;
import aQute.lib.io.IO;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pom {
    static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static XPathFactory xpf = XPathFactory.newInstance();
    String groupId;
    String artifactId;
    String version;
    List<Dependency> dependencies = new ArrayList<Dependency>();
    List<URL> repositories = new ArrayList<URL>();
    Maven maven;
    Exception exception;
    Properties properties = new Properties();
    URL repository;
    File artifact;

    public Pom(Maven maven) {
        this.maven = maven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File pomFile) throws Exception {
        DocumentBuilder db = dbf.newDocumentBuilder();
        System.out.println("PArsing " + pomFile.getAbsolutePath());
        Document doc = db.parse(pomFile);
        XPath xp = xpf.newXPath();
        Node parent = (Node)xp.evaluate("project/parent", doc, XPathConstants.NODE);
        if (parent != null && parent.hasChildNodes()) {
            Pom parentPom;
            String parentGroupId = xp.evaluate("groupId", parent);
            String parentArtifactId = xp.evaluate("artifactId", parent);
            String parentVersion = xp.evaluate("version", parent);
            String parentPath = xp.evaluate("relativePath", parent);
            if (parentPath != null && !parentPath.isEmpty()) {
                File parentFile = IO.getFile(pomFile.getParentFile(), parentPath);
                if (!parentFile.isFile()) {
                    throw new IllegalArgumentException("Pom " + pomFile + " specifies parent that does not exist: " + parentFile);
                }
                parentPom = new Pom(this.maven);
                parentPom.setFile(parentFile);
            } else {
                parentPom = this.maven.getPom(parentGroupId, parentArtifactId, parentVersion, new URL[0]);
            }
            this.dependencies.addAll(parentPom.dependencies);
            this.properties.putAll((Map<?, ?>)parentPom.properties);
            this.repositories.addAll(parentPom.repositories);
        }
        NodeList list = (NodeList)xp.evaluate("project/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            Dependency dep = new Dependency();
            String scope = xp.evaluate("scope", node).trim();
            dep.scope = scope.isEmpty() ? Scope.compile : Scope.valueOf(scope);
            dep.type = xp.evaluate("type", node);
            String opt = xp.evaluate("optional", node);
            dep.optional = opt != null && opt.equalsIgnoreCase("true");
            dep.groupId = xp.evaluate("groupId", node);
            dep.artifactId = xp.evaluate("artifactId", node);
            dep.version = xp.evaluate("version", node);
            this.dependencies.add(dep);
            NodeList exclusions = (NodeList)xp.evaluate("exclusions", node, XPathConstants.NODESET);
            for (int e = 0; e < exclusions.getLength(); ++e) {
                Node exc = exclusions.item(e);
                String exclGroupId = xp.evaluate("groupId", exc);
                String exclArtifactId = xp.evaluate("artifactId", exc);
                dep.exclusions.add(exclGroupId + "+" + exclArtifactId);
            }
        }
        NodeList propNodes = (NodeList)xp.evaluate("project/properties/*", doc, XPathConstants.NODESET);
        for (int i = 0; i < propNodes.getLength(); ++i) {
            Node node = propNodes.item(i);
            this.properties.setProperty(node.getNodeName(), node.getNodeValue());
        }
        NodeList repos = (NodeList)xp.evaluate("project/repositories/repository", doc, XPathConstants.NODESET);
        for (int i = 0; i < repos.getLength(); ++i) {
            Node node = repos.item(i);
            String urlString = node.getNodeValue().trim();
            this.repositories.add(new URL(urlString));
        }
        Pom pom = this;
        synchronized (pom) {
            this.groupId = xp.evaluate("project/groupId", doc);
            this.artifactId = xp.evaluate("project/artifactId", doc);
            this.version = xp.evaluate("project/version", doc);
            this.notifyAll();
        }
    }

    public String getArtifactId() throws Exception {
        this.block();
        return this.artifactId;
    }

    public String getGroupId() throws Exception {
        this.block();
        return this.groupId;
    }

    public String getVersion() throws Exception {
        this.block();
        return this.version;
    }

    public List<Dependency> getDependencies() throws Exception {
        this.block();
        return this.dependencies;
    }

    private synchronized void block() throws Exception {
        while (this.groupId == null && this.exception == null) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public List<Pom> getDependencies(Scope scope) throws Exception {
        ArrayList<Pom> result = new ArrayList<Pom>();
        result.add(this);
        ArrayList<Rover> queue = new ArrayList<Rover>();
        for (Dependency d : this.dependencies) {
            queue.add(new Rover(null, d));
        }
        while (!queue.isEmpty()) {
            Pom sub;
            Rover rover = (Rover)queue.remove(0);
            Dependency dep = rover.dependency;
            String name = dep.groupId + "+" + dep.artifactId;
            if (rover.excludes(name) || dep.scope != scope || dep.optional || result.contains(sub = this.maven.getPom(dep.groupId, dep.artifactId, dep.version, this.repository))) continue;
            result.add(sub);
            for (Dependency subd : sub.dependencies) {
                queue.add(new Rover(rover, subd));
            }
        }
        return result;
    }

    void setRepository(URL repo) {
        this.repository = repo;
    }

    public String toString() {
        return this.groupId + "+" + this.artifactId + "-" + this.version;
    }

    public synchronized File getArtifact() throws Exception {
        return this.maven.getArtifact(this.groupId, this.artifactId, this.version, this.repository);
    }

    static {
        dbf.setNamespaceAware(false);
    }

    class Rover {
        final Rover previous;
        final Dependency dependency;

        public Rover(Rover rover, Dependency d) {
            this.previous = rover;
            this.dependency = d;
        }

        public boolean excludes(String name) {
            return this.dependency.exclusions.contains(name) && this.previous != null && this.previous.excludes(name);
        }
    }

    public class Dependency {
        Scope scope;
        String type;
        boolean optional;
        String groupId;
        String artifactId;
        String version;
        Set<String> exclusions = new HashSet<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        compile,
        runtime,
        provided,
        system,
        import_,
        test;

    }
}

