/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.xml.parsers.ParserConfigurationException;
import org.fusesource.fabric.agent.download.AbstractDownloadTask;
import org.fusesource.fabric.agent.mvn.DownloadableArtifact;
import org.fusesource.fabric.agent.mvn.MavenConfiguration;
import org.fusesource.fabric.agent.mvn.MavenRepositoryURL;
import org.fusesource.fabric.agent.mvn.Parser;
import org.fusesource.fabric.agent.mvn.Version;
import org.fusesource.fabric.agent.mvn.VersionRange;
import org.fusesource.fabric.agent.utils.URLUtils;
import org.fusesource.fabric.agent.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenDownloadTask
extends AbstractDownloadTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadTask.class);
    private static final String Ix2 = "  ";
    private static final String Ix4 = "    ";
    private final MavenRepositoryURL system;
    private final MavenConfiguration configuration;

    public MavenDownloadTask(String url, MavenRepositoryURL system, MavenConfiguration configuration, ExecutorService executor) {
        super(url, executor);
        this.system = system;
        this.configuration = configuration;
    }

    @Override
    protected File download() throws Exception {
        DownloadableArtifact artifact;
        URL url;
        File file;
        Set<DownloadableArtifact> downloadables;
        Parser parser = new Parser(this.url.substring("mvn:".length()));
        if (!parser.getVersion().contains("SNAPSHOT") && !(downloadables = this.doCollectPossibleDownloads(parser, Collections.singletonList(this.system))).isEmpty() && (file = new File((url = (artifact = downloadables.iterator().next()).getArtifactURL()).getFile())).exists()) {
            return file;
        }
        downloadables = this.collectPossibleDownloads(parser);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Possible download locations for [" + this.url + "]");
            for (DownloadableArtifact artifact2 : downloadables) {
                LOG.trace(Ix2 + artifact2);
            }
        }
        for (DownloadableArtifact artifact2 : downloadables) {
            LOG.trace("Downloading [" + artifact2 + "]");
            try {
                this.configuration.enableProxy(artifact2.getArtifactURL());
                String repository = this.system.getFile().getAbsolutePath();
                if (!repository.endsWith("/")) {
                    repository = repository + "/";
                }
                InputStream is = artifact2.getInputStream();
                File file2 = new File(repository + parser.getArtifactPath());
                file2.getParentFile().mkdirs();
                if (!file2.getParentFile().isDirectory()) {
                    throw new IOException("Unable to create directory " + file2.getParentFile().toString());
                }
                File tmp = File.createTempFile("fabric-agent-", null, file2.getParentFile());
                FileOutputStream os = new FileOutputStream(tmp);
                MavenDownloadTask.copy(is, os);
                is.close();
                ((OutputStream)os).close();
                if (file2.exists() && !file2.delete()) {
                    throw new IOException("Unable to delete file: " + file2.toString());
                }
                if (!tmp.renameTo(file2)) {
                    throw new IOException("Unable to rename file " + tmp.toString() + " to " + file2.toString());
                }
                return file2;
            }
            catch (IOException ignore) {
                LOG.debug("  Could not download [" + artifact2 + "]");
                LOG.trace("  Reason [" + ignore.getClass().getName() + ": " + ignore.getMessage() + "]");
            }
        }
        throw new IOException("URL [" + this.url + "] could not be resolved.");
    }

    private Set<DownloadableArtifact> collectPossibleDownloads(Parser parser) throws MalformedURLException {
        ArrayList<MavenRepositoryURL> repositories = new ArrayList<MavenRepositoryURL>();
        repositories.addAll(this.configuration.getRepositories());
        repositories.add(this.system);
        repositories.add(this.configuration.getLocalRepository());
        if (parser.getRepositoryURL() != null) {
            repositories.add(repositories.size() == 0 ? 0 : 1, parser.getRepositoryURL());
        }
        return this.doCollectPossibleDownloads(parser, repositories);
    }

    private Set<DownloadableArtifact> collectDefaultPossibleDownloads(Parser parser) throws MalformedURLException {
        return this.doCollectPossibleDownloads(parser, this.configuration.getDefaultRepositories());
    }

    private Set<DownloadableArtifact> doCollectPossibleDownloads(Parser parser, List<MavenRepositoryURL> repositories) throws MalformedURLException {
        TreeSet<DownloadableArtifact> downloadables = new TreeSet<DownloadableArtifact>(new DownloadComparator());
        boolean isLatest = parser.getVersion().contains("LATEST");
        boolean isSnapshot = parser.getVersion().endsWith("SNAPSHOT");
        VersionRange versionRange = null;
        if (!isLatest && !isSnapshot) {
            try {
                versionRange = new VersionRange(parser.getVersion());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        boolean isVersionRange = versionRange != null;
        boolean isExactVersion = !isLatest && !isSnapshot && !isVersionRange;
        int priority = 0;
        for (MavenRepositoryURL repositoryURL : repositories) {
            LOG.debug("Collecting versions from repository [" + repositoryURL + "]");
            ++priority;
            try {
                if (isExactVersion) {
                    downloadables.add(this.resolveExactVersion(parser, repositoryURL, priority));
                    continue;
                }
                if (isSnapshot) {
                    DownloadableArtifact snapshot = this.resolveSnapshotVersion(parser, repositoryURL, priority, parser.getVersion());
                    downloadables.add(snapshot);
                    if (!snapshot.isLocalSnapshotBuild()) continue;
                    break;
                }
                Document metadata = this.getMetadata(repositoryURL.getURL(), new String[]{parser.getArtifactLocalMetdataPath(), parser.getArtifactMetdataPath()});
                if (isLatest) {
                    downloadables.add(this.resolveLatestVersion(parser, metadata, repositoryURL, priority));
                    continue;
                }
                downloadables.addAll(this.resolveRangeVersions(parser, metadata, repositoryURL, priority, versionRange));
            }
            catch (IOException ignore) {
                LOG.debug("  Skipping repository [" + repositoryURL + "], reason: " + ignore.getMessage());
            }
        }
        return downloadables;
    }

    private Document getMetadata(URL repositoryURL, String[] metadataLocations) throws IOException {
        LOG.debug("  Resolving metadata");
        InputStream inputStream = null;
        String foundLocation = null;
        for (String location : metadataLocations) {
            try {
                inputStream = this.prepareInputStream(repositoryURL, location);
                foundLocation = location;
                LOG.trace("    Metadata found: [" + location + "]");
                break;
            }
            catch (IOException ignore) {
                LOG.trace("    Metadata not found: [" + location + "]");
            }
        }
        if (inputStream == null) {
            throw new IOException("Metadata not found in repository [" + repositoryURL + "]");
        }
        try {
            return XmlUtils.parseDoc(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw MavenDownloadTask.initIOException("Metadata [" + foundLocation + "] could not be parsed.", e);
        }
        catch (SAXException e) {
            throw MavenDownloadTask.initIOException("Metadata [" + foundLocation + "] could not be parsed.", e);
        }
    }

    private DownloadableArtifact resolveExactVersion(Parser parser, MavenRepositoryURL repositoryURL, int priority) throws IOException {
        if (!repositoryURL.isReleasesEnabled()) {
            throw new IOException("Releases not enabled");
        }
        LOG.debug("  Resolving exact version");
        return new DownloadableArtifact(parser.getVersion(), priority, repositoryURL.getURL(), parser.getArtifactPath(), false, this.configuration.getCertificateCheck());
    }

    private DownloadableArtifact resolveLatestVersion(Parser parser, Document metadata, MavenRepositoryURL repositoryURL, int priority) throws IOException {
        LOG.debug("  Resolving latest version");
        String version = XmlUtils.getTextContentOfElement(metadata, "versioning/versions/version[last]");
        if (version != null) {
            if (version.endsWith("SNAPSHOT")) {
                return this.resolveSnapshotVersion(parser, repositoryURL, priority, version);
            }
            return new DownloadableArtifact(version, priority, repositoryURL.getURL(), parser.getArtifactPath(version), false, this.configuration.getCertificateCheck());
        }
        throw new IOException("LATEST version could not be resolved.");
    }

    private DownloadableArtifact resolveSnapshotVersion(Parser parser, MavenRepositoryURL repositoryURL, int priority, String version) throws IOException {
        if (!repositoryURL.isSnapshotsEnabled()) {
            throw new IOException("Snapshots not enabled");
        }
        LOG.debug("  Resolving snapshot version [" + version + "]");
        try {
            Document snapshotMetadata = this.getMetadata(repositoryURL.getURL(), new String[]{parser.getVersionLocalMetadataPath(version), parser.getVersionMetadataPath(version)});
            String timestamp = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/timestamp");
            String buildNumber = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/buildNumber");
            String localSnapshot = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/snapshot/localCopy");
            if (timestamp != null && buildNumber != null) {
                return new DownloadableArtifact(parser.getSnapshotVersion(version, timestamp, buildNumber), priority, repositoryURL.getURL(), parser.getSnapshotPath(version, timestamp, buildNumber), localSnapshot != null, this.configuration.getCertificateCheck());
            }
            String lastUpdated = XmlUtils.getTextContentOfElement(snapshotMetadata, "versioning/lastUpdated");
            if (lastUpdated != null && lastUpdated.length() > 8) {
                lastUpdated = lastUpdated.substring(0, 8) + "." + lastUpdated.substring(8);
                return new DownloadableArtifact(parser.getSnapshotVersion(version, lastUpdated, "0"), priority, repositoryURL.getURL(), parser.getArtifactPath(version), localSnapshot != null, this.configuration.getCertificateCheck());
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return new DownloadableArtifact(parser.getVersion(), priority, repositoryURL.getURL(), parser.getArtifactPath(), false, this.configuration.getCertificateCheck());
    }

    private List<DownloadableArtifact> resolveRangeVersions(Parser parser, Document metadata, MavenRepositoryURL repositoryURL, int priority, VersionRange versionRange) throws IOException {
        LOG.debug("  Resolving versions in range [" + versionRange + "]");
        ArrayList<DownloadableArtifact> downladables = new ArrayList<DownloadableArtifact>();
        List<Element> elements = XmlUtils.getElements(metadata, "versioning/versions/version");
        if (elements != null && elements.size() > 0) {
            for (Element element : elements) {
                Version version;
                String versionString = XmlUtils.getTextContent(element);
                if (versionString == null || !versionRange.includes(version = new Version(versionString))) continue;
                if (versionString.endsWith("SNAPSHOT")) {
                    downladables.add(this.resolveSnapshotVersion(parser, repositoryURL, priority, versionString));
                    continue;
                }
                downladables.add(new DownloadableArtifact(versionString, priority, repositoryURL.getURL(), parser.getArtifactPath(versionString), false, this.configuration.getCertificateCheck()));
            }
        }
        return downladables;
    }

    private InputStream prepareInputStream(URL repositoryURL, String path) throws IOException {
        String repository = repositoryURL.toExternalForm();
        if (!repository.endsWith("/")) {
            repository = repository + "/";
        }
        this.configuration.enableProxy(repositoryURL);
        URL url = new URL(repository + path);
        LOG.trace("Reading " + url.toExternalForm());
        return URLUtils.prepareInputStream(url, this.configuration.getCertificateCheck() == false);
    }

    private static class DownloadComparator
    implements Comparator<DownloadableArtifact> {
        private DownloadComparator() {
        }

        @Override
        public int compare(DownloadableArtifact first, DownloadableArtifact second) {
            int result = -1 * first.getVersion().compareTo(second.getVersion());
            if (result == 0) {
                if (first.getPriority() < second.getPriority()) {
                    result = -1;
                } else if (first.getPriority() > second.getPriority()) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

