/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.util.internal.MessageUtil;
import org.osgi.framework.Version;

public final class VersionRange {
    private String version;
    private Version minimumVersion;
    private Version maximumVersion;
    private boolean minimumExclusive;
    private boolean maximumExclusive;
    private static final Pattern versionCapture = Pattern.compile("\"?(.*?)\"?$");

    public VersionRange(String version) {
        this.version = version;
        this.processVersionAttribute(version);
    }

    public VersionRange(String version, boolean exactVersion) {
        if (exactVersion) {
            this.processExactVersionAttribute(version);
        } else {
            this.version = version;
            this.processVersionAttribute(this.version);
        }
        this.assertInvariants();
    }

    private VersionRange(Version maximumVersion, boolean maximumExclusive, Version minimumVersion, boolean minimumExclusive) {
        this.maximumVersion = maximumVersion;
        this.maximumExclusive = maximumExclusive;
        this.minimumVersion = minimumVersion;
        this.minimumExclusive = minimumExclusive;
        this.assertInvariants();
    }

    public String toString() {
        if (this.version == null) {
            this.version = this.maximumVersion == null ? this.minimumVersion.toString() : (this.minimumExclusive ? "(" : "[") + this.minimumVersion + "," + this.maximumVersion + (this.maximumExclusive ? ")" : "]");
        }
        return this.version;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.minimumVersion.hashCode();
        result = 31 * result + (this.minimumExclusive ? 1 : 0);
        result = 31 * result + (this.maximumVersion != null ? this.maximumVersion.hashCode() : 0);
        result = 31 * result + (this.maximumExclusive ? 1 : 0);
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (this == other) {
            result = true;
        } else if (other instanceof VersionRange) {
            VersionRange vr = (VersionRange)other;
            result = this.minimumVersion.equals((Object)vr.minimumVersion) && this.minimumExclusive == vr.minimumExclusive && (this.maximumVersion == null ? vr.maximumVersion == null : this.maximumVersion.equals((Object)vr.maximumVersion)) && this.maximumExclusive == vr.maximumExclusive;
        }
        return result;
    }

    public Version getExactVersion() {
        Version v = null;
        if (this.isExactVersion()) {
            v = this.getMinimumVersion();
        }
        return v;
    }

    public Version getMaximumVersion() {
        return this.maximumVersion;
    }

    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    public boolean isMaximumExclusive() {
        return this.maximumExclusive;
    }

    public boolean isMaximumUnbounded() {
        boolean unbounded = this.maximumVersion == null;
        return unbounded;
    }

    public boolean isMinimumExclusive() {
        return this.minimumExclusive;
    }

    private boolean processExactVersionAttribute(String version) throws IllegalArgumentException {
        boolean success = this.processVersionAttribute(version);
        if (this.maximumVersion == null) {
            this.maximumVersion = this.minimumVersion;
        }
        if (!this.minimumVersion.equals((Object)this.maximumVersion)) {
            throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0011E", version));
        }
        if (!this.isExactVersion()) {
            throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0009E", version));
        }
        return success;
    }

    private boolean processVersionAttribute(String version) throws IllegalArgumentException {
        boolean success = false;
        if (version == null) {
            throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0010E", new Object[0]));
        }
        Matcher matches = versionCapture.matcher(version);
        if (matches.matches()) {
            String versions = matches.group(1);
            if ((versions.startsWith("[") || versions.startsWith("(")) && (versions.endsWith("]") || versions.endsWith(")"))) {
                if (versions.startsWith("[")) {
                    this.minimumExclusive = false;
                } else if (versions.startsWith("(")) {
                    this.minimumExclusive = true;
                }
                if (versions.endsWith("]")) {
                    this.maximumExclusive = false;
                } else if (versions.endsWith(")")) {
                    this.maximumExclusive = true;
                }
                int index = versions.indexOf(44);
                String minVersion = versions.substring(1, index);
                String maxVersion = versions.substring(index + 1, versions.length() - 1);
                try {
                    this.minimumVersion = new Version(minVersion.trim());
                    this.maximumVersion = new Version(maxVersion.trim());
                    success = true;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0009E", version), nfe);
                }
            } else {
                try {
                    this.minimumVersion = versions.trim().length() == 0 ? new Version(0, 0, 0) : new Version(versions.trim());
                    success = true;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0009E", version), nfe);
                }
            }
        } else {
            throw new IllegalArgumentException(MessageUtil.getMessage("UTIL0009E", version));
        }
        return success;
    }

    private void assertInvariants() {
        if (this.minimumVersion == null || !this.isRangeValid(this.minimumVersion, this.minimumExclusive, this.maximumVersion, this.maximumExclusive)) {
            IllegalArgumentException e = new IllegalArgumentException();
            throw e;
        }
    }

    private boolean isRangeValid(Version min, boolean minExclusive, Version max, boolean maxExclusive) {
        int minMaxCompare;
        int n = minMaxCompare = max == null ? -1 : min.compareTo(max);
        boolean result = minMaxCompare > 0 ? false : minMaxCompare != 0 || !minExclusive && !maxExclusive;
        return result;
    }

    public boolean matches(Version version) {
        boolean result;
        if (this.getMaximumVersion() == null) {
            result = this.getMinimumVersion().compareTo(version) <= 0;
        } else {
            int minN = this.isMinimumExclusive() ? 0 : 1;
            int maxN = this.isMaximumExclusive() ? 0 : 1;
            result = this.getMinimumVersion().compareTo(version) < minN && version.compareTo(this.getMaximumVersion()) < maxN;
        }
        return result;
    }

    public boolean isExactVersion() {
        return this.minimumVersion.equals((Object)this.maximumVersion) && this.minimumExclusive == this.maximumExclusive && !this.minimumExclusive;
    }

    public VersionRange intersect(VersionRange r) {
        boolean newMaximumExclusive;
        Version newMaximumVersion;
        boolean newMinimumExclusive;
        Version newMinimumVersion;
        int minCompare = this.minimumVersion.compareTo(r.getMinimumVersion());
        if (minCompare > 0) {
            newMinimumVersion = this.minimumVersion;
            newMinimumExclusive = this.minimumExclusive;
        } else if (minCompare < 0) {
            newMinimumVersion = r.getMinimumVersion();
            newMinimumExclusive = r.isMinimumExclusive();
        } else {
            newMinimumVersion = this.minimumVersion;
            boolean bl = newMinimumExclusive = this.minimumExclusive || r.isMinimumExclusive();
        }
        if (this.maximumVersion == null) {
            newMaximumVersion = r.getMaximumVersion();
            newMaximumExclusive = r.isMaximumExclusive();
        } else if (r.getMaximumVersion() == null) {
            newMaximumVersion = this.maximumVersion;
            newMaximumExclusive = this.maximumExclusive;
        } else {
            int maxCompare = this.maximumVersion.compareTo(r.getMaximumVersion());
            if (maxCompare < 0) {
                newMaximumVersion = this.maximumVersion;
                newMaximumExclusive = this.maximumExclusive;
            } else if (maxCompare > 0) {
                newMaximumVersion = r.getMaximumVersion();
                newMaximumExclusive = r.isMaximumExclusive();
            } else {
                newMaximumVersion = this.maximumVersion;
                newMaximumExclusive = this.maximumExclusive || r.isMaximumExclusive();
            }
        }
        VersionRange result = this.isRangeValid(newMinimumVersion, newMinimumExclusive, newMaximumVersion, newMaximumExclusive) ? new VersionRange(newMaximumVersion, newMaximumExclusive, newMinimumVersion, newMinimumExclusive) : null;
        return result;
    }

    public static VersionRange parseVersionRange(String s) throws IllegalArgumentException {
        return new VersionRange(s);
    }

    public static VersionRange parseVersionRange(String s, boolean exactVersion) throws IllegalArgumentException {
        return new VersionRange(s, exactVersion);
    }
}

