/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.maven.PomFromManifest;
import aQute.bnd.settings.Settings;
import aQute.lib.collections.LineCollection;
import aQute.lib.io.IO;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.libg.command.Command;
import aQute.libg.header.OSGiHeader;
import aQute.libg.reporter.Reporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenCommand
extends Processor {
    final Settings settings = new Settings();
    String repository = "nexus";
    String url = "http://oss.sonatype.org/service/local/staging/deploy/maven2";
    String homedir;
    String keyname;
    File temp;
    String scm;
    String passphrase;
    Reporter reporter;
    List<String> developers = new ArrayList<String>();

    public void run(String[] args, int i) throws Exception {
        this.temp = File.createTempFile("bnd", "");
        if (i >= args.length) {
            this.help();
            return;
        }
        String cmd = args[i++];
        while (i < args.length && args[i].startsWith("-")) {
            String option = args[i];
            if (option.equals("-url")) {
                this.repository = args[++i];
            } else if (option.equals("-temp")) {
                this.temp = this.getFile(args[++i]);
            } else if (option.equals("-scm")) {
                this.scm = args[++i];
            } else if (option.equals("-developer")) {
                this.developers.add(args[++i]);
            } else if (option.equals("-passphrase")) {
                this.passphrase = args[++i];
            } else if (option.equals("-url")) {
                this.homedir = args[++i];
            } else if (option.equals("-keyname")) {
                this.keyname = args[++i];
            } else {
                this.error("Invalid command ", new Object[0]);
            }
            ++i;
        }
        this.temp.mkdirs();
        if (cmd.equals("settings")) {
            this.settings();
        } else if (cmd.equals("help")) {
            this.help();
        } else if (cmd.equals("deploy")) {
            this.bundle(args, i);
        } else {
            this.error("No such command %s, type help", cmd);
        }
    }

    private void help() {
        System.err.println("Usage:\n");
        System.err.println("  deploy [-url repo] [-passphrase passphrase] [-homedir homedir] [-keyname keyname] bundle ...");
        System.err.println("  settings");
    }

    public void settings() throws FileNotFoundException, Exception {
        File userHome = new File(System.getProperty("user.home"));
        File m2 = new File(userHome, ".m2");
        if (!m2.isDirectory()) {
            this.error("There is no m2 directory at %s", userHome);
            return;
        }
        File settings = new File(m2, "settings.xml");
        if (!settings.isFile()) {
            this.error("There is no settings file at '%s'", settings.getAbsolutePath());
            return;
        }
        FileReader rdr = new FileReader(settings);
        LineCollection lc = new LineCollection(new BufferedReader(rdr));
        while (lc.hasNext()) {
            System.out.println(lc.next());
        }
    }

    void bundle(String[] args, int i) throws Exception {
        if (this.developers.isEmpty()) {
            String email = this.settings.globalGet("email", null);
            if (email == null) {
                this.error("No developer email set, you can set global default email with: bnd global email Peter.Kriens@aQute.biz", new Object[0]);
            } else {
                this.developers.add(email);
            }
        }
        while (i < args.length) {
            String jar;
            File f;
            if (!(f = this.getFile(jar = args[i++])).isFile()) {
                this.error("File does not exist: %s", f.getAbsoluteFile());
                continue;
            }
            this.deploy(f);
        }
    }

    void execute(String[] args, int i) throws Exception {
        while (i < args.length) {
            String pom;
            File f;
            if (!(f = this.getFile(pom = args[i++])).isFile()) {
                this.error("File does not exist: %s", f.getAbsoluteFile());
                continue;
            }
            this.deploy(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deploy(File f) throws Exception {
        Jar jar = new Jar(f);
        File original = MavenCommand.getFile(this.temp, "original");
        original.mkdirs();
        jar.expand(original);
        try {
            Manifest manifest = jar.getManifest();
            PomFromManifest pom = new PomFromManifest(manifest);
            if (this.scm != null) {
                pom.setSCM(this.scm);
            }
            for (String d : this.developers) {
                pom.addDeveloper(d);
            }
            Set<String> exports = OSGiHeader.parseHeader(manifest.getMainAttributes().getValue("Export-Package")).keySet();
            Jar javadoc = this.javadoc(MavenCommand.getFile(original, "OSGI-OPT/src"), f, exports);
            if (javadoc == null) {
                return;
            }
            this.addClose(javadoc);
            Jar binary = new Jar("binary");
            Jar source = new Jar("source");
            this.addClose(binary);
            this.addClose(source);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (!entry.getKey().startsWith("OSGI-OPT")) {
                    binary.putResource(entry.getKey(), entry.getValue());
                }
                if (!entry.getKey().startsWith("OSGI-OPT/src")) continue;
                binary.putResource(entry.getKey().substring("OSGI-OPT/src/".length()), entry.getValue());
            }
            String prefix = pom.getArtifactId() + "-" + pom.getVersion();
            File bundle = new File(this.temp, "bundle");
            bundle.mkdirs();
            File binaryFile = new File(bundle, prefix + ".jar");
            File sourceFile = new File(bundle, prefix + "-sources.jar");
            File javadocFile = new File(bundle, prefix + "-javadoc.jar");
            File pomFile = new File(bundle, "pom.xml").getAbsoluteFile();
            IO.copy(pom.openInputStream(), pomFile);
            this.sign(pomFile);
            binary.write(binaryFile);
            this.sign(binaryFile);
            source.write(sourceFile);
            this.sign(sourceFile);
            javadoc.write(javadocFile);
            this.sign(javadocFile);
            Jar jarred = new Jar(bundle);
            File jarredFile = new File(this.temp, "bundle.jar");
            jarred.write(jarredFile);
        }
        finally {
            jar.close();
        }
    }

    private void sign(File file) throws Exception {
        File asc = new File(file.getParentFile(), file.getName() + ".asc");
        asc.delete();
        Command command = new Command();
        command.setTrace();
        command.add(this.getProperty("gpgp", "gpg"));
        if (this.passphrase != null) {
            command.add("--passphrase", this.passphrase);
        }
        command.add("-ab", "--sign");
        command.add(file.getAbsolutePath());
        System.out.println(command);
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        int result = command.execute(stdout, stderr);
        if (result != 0) {
            this.error("gpg signing %s failed because %s", file, "" + stdout + stderr);
        }
    }

    private Jar javadoc(File source, File binary, Set<String> exports) throws Exception {
        File tmp = new File(this.temp, "javadoc");
        tmp.mkdirs();
        Command command = new Command();
        command.add(this.getProperty("javadoc", "javadoc"));
        command.add("-quiet");
        command.add("-protected");
        command.add("-classpath");
        command.add(binary.getAbsolutePath());
        command.add("-d");
        command.add(tmp.getAbsolutePath());
        command.add("-charset");
        command.add("UTF-8");
        command.add("-sourcepath");
        command.add(source.getAbsolutePath());
        for (String packageName : exports) {
            command.add(packageName);
        }
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        System.out.println(command);
        int result = command.execute(out, err);
        if (result == 0) {
            this.warning("Error during execution of javadoc command: %s / %s", out, err);
        }
        Jar jar = new Jar(tmp);
        this.addClose(jar);
        return jar;
    }
}

