/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.fusesource.fabric.agent.utils.AllCertificatesTrustManager;
import org.fusesource.fabric.agent.utils.Base64Encoder;
import org.fusesource.fabric.agent.utils.NullArgumentException;

public class URLUtils {
    private URLUtils() {
    }

    public static URLConnection prepareForAuthentication(URLConnection connection) {
        NullArgumentException.validateNotNull(connection, "url connection cannot be null");
        if (connection.getURL().getUserInfo() != null) {
            String base64Encoded = Base64Encoder.encode(connection.getURL().getUserInfo());
            base64Encoded = base64Encoded.replaceAll("\n", "");
            connection.setRequestProperty("Authorization", "Basic " + base64Encoded);
        }
        return connection;
    }

    public static URLConnection prepareForSSL(URLConnection connection) {
        NullArgumentException.validateNotNull(connection, "url connection cannot be null");
        URLConnection conn = connection;
        if (conn instanceof JarURLConnection) {
            try {
                conn = ((JarURLConnection)connection).getJarFileURL().openConnection();
                conn.connect();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
        }
        if (conn instanceof HttpsURLConnection) {
            try {
                SSLContext ctx = SSLContext.getInstance("SSLv3");
                ctx.init(null, new TrustManager[]{new AllCertificatesTrustManager()}, null);
                ((HttpsURLConnection)conn).setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not prepare connection for HTTPS.", e);
            }
        }
        return connection;
    }

    public static InputStream prepareInputStream(URL url, boolean acceptAnyCertificate) throws IOException {
        URLConnection conn = url.openConnection();
        URLUtils.prepareForAuthentication(conn);
        if (acceptAnyCertificate) {
            URLUtils.prepareForSSL(conn);
        }
        return conn.getInputStream();
    }
}

