/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.download;

import java.net.MalformedURLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.fusesource.fabric.agent.download.DownloadFuture;
import org.fusesource.fabric.agent.download.FutureListener;
import org.fusesource.fabric.agent.download.MavenDownloadTask;
import org.fusesource.fabric.agent.download.SimpleDownloadTask;
import org.fusesource.fabric.agent.mvn.MavenConfiguration;
import org.fusesource.fabric.agent.mvn.MavenRepositoryURL;

public class DownloadManager {
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final MavenConfiguration configuration;
    private final MavenRepositoryURL system;

    public DownloadManager(MavenConfiguration configuration) throws MalformedURLException {
        this.configuration = configuration;
        String systemRepo = "file:" + System.getProperty("karaf.home") + "/" + System.getProperty("karaf.default.repository") + "@snapshots";
        this.system = new MavenRepositoryURL(systemRepo);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public DownloadFuture download(String url) throws MalformedURLException {
        String mvnUrl = url;
        if (mvnUrl.startsWith("wrap:") && (mvnUrl = mvnUrl.substring("wrap:".length())).contains("$")) {
            mvnUrl = mvnUrl.substring(0, mvnUrl.lastIndexOf(36) - 1);
        }
        if (mvnUrl.startsWith("blueprint:") || mvnUrl.startsWith("spring:")) {
            mvnUrl = mvnUrl.substring(mvnUrl.indexOf(58) + 1);
        }
        if (mvnUrl.startsWith("mvn:")) {
            MavenDownloadTask task = new MavenDownloadTask(url, this.system, this.configuration, this.executor);
            this.executor.submit(task);
            if (!mvnUrl.equals(url)) {
                final SimpleDownloadTask download = new SimpleDownloadTask(url, this.executor);
                task.addListener(new FutureListener<DownloadFuture>(){

                    @Override
                    public void operationComplete(DownloadFuture future) {
                        DownloadManager.this.executor.submit(download);
                    }
                });
                return download;
            }
            return task;
        }
        SimpleDownloadTask download = new SimpleDownloadTask(url, this.executor);
        this.executor.submit(download);
        return download;
    }
}

