/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.mapping;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.mapping.AbstractNodeHandler;
import de.pdark.decentxml.mapping.AttributeMapping;
import de.pdark.decentxml.mapping.MappingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexElementHandler
extends AbstractNodeHandler {
    private ParameterProvider[] parameterProviders;

    public ComplexElementHandler(Object handler, Method method) {
        super(handler, method);
        this.processArguments();
    }

    private void processArguments() {
        int N = this.method.getParameterTypes().length;
        this.parameterProviders = new ParameterProvider[N];
        Annotation[][] annotations = this.method.getParameterAnnotations();
        for (int i = 0; i < N; ++i) {
            AttributeMapping ann = this.getAnnotation(annotations[i], AttributeMapping.class);
            Class<?> type = this.method.getParameterTypes()[i];
            if (ann == null) {
                if (Element.class.isAssignableFrom(type)) {
                    this.parameterProviders[i] = new ParameterProvider(){

                        public Object value(Element node) {
                            return node;
                        }
                    };
                }
            } else {
                String name = ann.value();
                if (name == null || name.length() == 0) {
                    name = ann.name();
                }
                if (name == null || name.length() == 0) {
                    throw new MappingException("Missing attribute name in annotation AttributeName for " + this.method);
                }
                boolean required = ann.required();
                if (String.class.equals(type)) {
                    this.parameterProviders[i] = new StringParameterProvider(name);
                } else if (Attribute.class.isAssignableFrom(type)) {
                    this.parameterProviders[i] = new AttributeParameterProvider(name);
                } else if (Integer.TYPE.equals(type)) {
                    this.parameterProviders[i] = new IntegerParameterProvider(name);
                    required = true;
                } else if (Boolean.TYPE.equals(type)) {
                    this.parameterProviders[i] = new BooleanParameterProvider(name, ann);
                    required = true;
                } else if (Integer.class.equals(type)) {
                    this.parameterProviders[i] = new IntegerParameterProvider(name);
                } else if (Boolean.class.equals(type)) {
                    this.parameterProviders[i] = new IntegerParameterProvider(name);
                }
                if (required && this.parameterProviders[i] != null) {
                    this.parameterProviders[i] = new RequiredWrapper(name, this.parameterProviders[i]);
                }
            }
            if (this.parameterProviders[i] != null) continue;
            throw new MappingException("Can't create parameter provider for parameter " + (i + 1) + " (" + type + ") of " + this.method);
        }
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> key) {
        for (Annotation a : annotations) {
            if (!key.equals(a.annotationType())) continue;
            return (T)a;
        }
        return null;
    }

    @Override
    public void invoke(Node node) throws Exception {
        Element element = (Element)node;
        int N = this.method.getParameterTypes().length;
        Object[] parameters = new Object[N];
        for (int i = 0; i < N; ++i) {
            parameters[i] = this.parameterProviders[i].value(element);
        }
        try {
            this.method.invoke(this.handler, parameters);
        }
        catch (Exception e) {
            String msg = this.toString(parameters);
            throw new MappingException("Error invoking " + this.method + " with the parameters:" + msg, e);
        }
    }

    private String toString(Object[] parameters) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            buffer.append('\n');
            buffer.append(i);
            buffer.append(": ");
            Object p = parameters[i];
            if (p == null) {
                buffer.append("null");
                continue;
            }
            buffer.append("[");
            buffer.append(p.getClass());
            buffer.append("] ");
            buffer.append(p.toString());
        }
        return buffer.toString();
    }

    private static class RequiredWrapper
    implements ParameterProvider {
        private final String name;
        private final ParameterProvider delegate;

        public RequiredWrapper(String name, ParameterProvider delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        public Object value(Element node) {
            if (null == node.getAttribute(this.name)) {
                throw new MappingException("Required attribute \"" + this.name + "\" is missing: " + node);
            }
            return this.delegate.value(node);
        }
    }

    private static class AttributeParameterProvider
    implements ParameterProvider {
        private final String name;

        public AttributeParameterProvider(String name) {
            this.name = name;
        }

        public Object value(Element node) {
            return node.getAttribute(this.name);
        }
    }

    private static class BooleanParameterProvider
    implements ParameterProvider {
        private final String name;
        private final String[] trueValues;
        private final String[] falseValues;

        public BooleanParameterProvider(String name, AttributeMapping ann) {
            this.name = name;
            if (ann.trueValues().length == 0 && ann.falseValues().length == 0) {
                this.trueValues = new String[]{"1", "on", "true", "y", "yes"};
                this.falseValues = null;
            } else {
                this.trueValues = ann.trueValues().length == 0 ? null : ann.trueValues();
                String[] stringArray = this.falseValues = ann.falseValues().length == 0 ? null : ann.falseValues();
            }
            if (this.trueValues != null) {
                Arrays.sort(this.trueValues);
            }
            if (this.falseValues != null) {
                Arrays.sort(this.falseValues);
            }
        }

        public Object value(Element node) {
            String value = node.getAttributeValue(this.name).toLowerCase();
            if (value == null) {
                return null;
            }
            if (this.trueValues != null && Arrays.binarySearch(this.trueValues, value) >= 0) {
                return Boolean.TRUE;
            }
            if (this.falseValues != null && Arrays.binarySearch(this.falseValues, value) >= 0) {
                return Boolean.FALSE;
            }
            if (this.trueValues != null && this.falseValues != null) {
                throw new MappingException("Failed to convert the attribute " + this.name + "=\"" + value + "\" to boolean. " + "Allowed values for true are: " + Arrays.toString(this.trueValues) + ". " + "Allowed values for false are: " + Arrays.toString(this.trueValues));
            }
            return this.trueValues == null ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class IntegerParameterProvider
    implements ParameterProvider {
        private final String name;

        public IntegerParameterProvider(String name) {
            this.name = name;
        }

        public Object value(Element node) {
            String value = node.getAttributeValue(this.name);
            if (value == null) {
                return null;
            }
            try {
                return new Integer(value);
            }
            catch (NumberFormatException e) {
                throw new MappingException("Failed to convert the attribute " + this.name + "=\"" + value + "\" to integer", e);
            }
        }
    }

    private static class StringParameterProvider
    implements ParameterProvider {
        private final String name;

        public StringParameterProvider(String name) {
            this.name = name;
        }

        public Object value(Element node) {
            return node.getAttributeValue(this.name);
        }
    }

    private static interface ParameterProvider {
        public Object value(Element var1);
    }
}

