/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.EntityResolver;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;

public class Entity
extends BasicNode {
    private EntityResolver resolver;

    public Entity(Token token, EntityResolver resolver) {
        super(token);
        this.resolver = resolver;
    }

    public Entity(String name) {
        super(XMLTokenizer.Type.ENTITY, name.charAt(0) == '&' ? name : "&" + name + ";");
    }

    public static Entity createDecimalEntity(int unicode) {
        Entity.checkUnicode(unicode);
        return new Entity("&#" + unicode + ";");
    }

    public static void checkUnicode(int unicode) {
        if (unicode < 0) {
            throw new IllegalArgumentException("unicode must be >= 0: " + unicode + " 0x" + Integer.toHexString(unicode));
        }
        if (unicode > 65535) {
            throw new IllegalArgumentException("unicode must be <= 65535: " + unicode + " 0x" + Integer.toHexString(unicode));
        }
    }

    public static Entity createHexEntity(int unicode) {
        Entity.checkUnicode(unicode);
        return new Entity("&#x" + Integer.toString(unicode, 16) + ";");
    }

    public void setResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }

    public String getName() {
        String name = this.getValue();
        return name.substring(1, name.length() - 1);
    }

    public String getText() {
        return this.resolver == null ? this.getValue() : this.resolver.expand(this.getValue());
    }

    public boolean isWhitespace() {
        String s = this.getText();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Entity createClone() {
        return new Entity(this.getValue());
    }

    public Entity copy(Node orig) {
        super.copy(orig);
        Entity other = (Entity)orig;
        this.resolver = other.resolver;
        return this;
    }

    public Entity copy() {
        return (Entity)super.copy();
    }
}

