/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AsyncExecutionAspectSupport
implements BeanFactoryAware {
    private final Map<Method, AsyncTaskExecutor> executors = new HashMap<Method, AsyncTaskExecutor>();
    private Executor defaultExecutor;
    private BeanFactory beanFactory;

    public AsyncExecutionAspectSupport(Executor defaultExecutor) {
        this.setExecutor(defaultExecutor);
    }

    public void setExecutor(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected AsyncTaskExecutor determineAsyncExecutor(Method method) {
        if (!this.executors.containsKey(method)) {
            Executor executor = this.defaultExecutor;
            String qualifier = this.getExecutorQualifier(method);
            if (StringUtils.hasLength(qualifier)) {
                Assert.notNull(this.beanFactory, "BeanFactory must be set on " + this.getClass().getSimpleName() + " to access qualified executor [" + qualifier + "]");
                executor = BeanFactoryAnnotationUtils.qualifiedBeanOfType(this.beanFactory, Executor.class, qualifier);
            }
            if (executor instanceof AsyncTaskExecutor) {
                this.executors.put(method, (AsyncTaskExecutor)executor);
            } else if (executor != null) {
                this.executors.put(method, new TaskExecutorAdapter(executor));
            }
        }
        return this.executors.get(method);
    }

    protected abstract String getExecutorQualifier(Method var1);
}

