/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedPersistentQueueMessageListenerContainer
extends DefaultJmsMessageListenerContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SharedPersistentQueueMessageListenerContainer.class);
    private String fixedMessageSelector;
    private MessageSelectorCreator creator;

    public SharedPersistentQueueMessageListenerContainer(JmsEndpoint endpoint, String fixedMessageSelector) {
        super(endpoint, false);
        this.fixedMessageSelector = fixedMessageSelector;
    }

    public SharedPersistentQueueMessageListenerContainer(JmsEndpoint endpoint, MessageSelectorCreator creator) {
        super(endpoint, false);
        this.creator = creator;
    }

    @Override
    public String getMessageSelector() {
        String id = null;
        if (this.fixedMessageSelector != null) {
            id = this.fixedMessageSelector;
        } else if (this.creator != null) {
            id = this.creator.get();
        }
        LOG.trace("Using MessageSelector[{}]", (Object)id);
        return id;
    }
}

