/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileLockExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 1000L;
    private FileLock lock;
    private String lockFileName;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        block9: {
            if (!super.acquireExclusiveReadLock(operations, file, exchange)) {
                return false;
            }
            File target = new File(file.getAbsoluteFilePath());
            LOG.trace("Waiting for exclusive read lock to file: {}", target);
            try {
                FileChannel channel = new RandomAccessFile(target, "rw").getChannel();
                boolean exclusive = false;
                StopWatch watch = new StopWatch();
                while (!exclusive) {
                    long delta;
                    if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                        LOG.warn("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + target);
                        return false;
                    }
                    try {
                        this.lock = this.timeout > 0L ? channel.tryLock() : channel.lock();
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                    if (this.lock != null) {
                        LOG.trace("Acquired exclusive read lock: {} to file: {}", this.lock, (Object)target);
                        this.lockFileName = target.getName();
                        exclusive = true;
                        continue;
                    }
                    boolean interrupted = this.sleep();
                    if (!interrupted) continue;
                    return false;
                }
            }
            catch (IOException e) {
                if (this.timeout == 0L) {
                    throw e;
                }
                LOG.debug("Cannot acquire read lock. Will try again.", e);
                boolean interrupted = this.sleep();
                if (!interrupted) break block9;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        super.releaseExclusiveReadLock(operations, file, exchange);
        if (this.lock != null) {
            FileChannel channel = this.lock.channel();
            try {
                this.lock.release();
            }
            finally {
                IOHelper.close((Closeable)channel, "while acquiring exclusive read lock for file: " + this.lockFileName, LOG);
            }
        }
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }
}

