/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private Set<String> cacheNames = new LinkedHashSet<String>();

    @Override
    public void afterPropertiesSet() {
        Collection<? extends Cache> caches = this.loadCaches();
        this.cacheMap.clear();
        this.cacheNames.clear();
        for (Cache cache : caches) {
            this.cacheMap.put(cache.getName(), cache);
            this.cacheNames.add(cache.getName());
        }
    }

    protected final void addCache(Cache cache) {
        this.cacheMap.put(cache.getName(), cache);
        this.cacheNames.add(cache.getName());
    }

    @Override
    public Cache getCache(String name) {
        return (Cache)this.cacheMap.get(name);
    }

    @Override
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }

    protected abstract Collection<? extends Cache> loadCaches();
}

