/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleBackwardsCompatibleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public class SimpleLanguage
implements Language,
IsSingleton {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    protected boolean allowEscape = true;

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Predicate createPredicate(String expression) {
        ObjectHelper.notNull(expression, "expression");
        Predicate answer = SimpleBackwardsCompatibleParser.parsePredicate(expression, this.allowEscape);
        if (answer == null) {
            SimplePredicateParser parser = new SimplePredicateParser(expression, this.allowEscape);
            answer = parser.parsePredicate();
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        ObjectHelper.notNull(expression, "expression");
        Expression answer = SimpleBackwardsCompatibleParser.parseExpression(expression, this.allowEscape);
        if (answer == null) {
            SimpleExpressionParser parser = new SimpleExpressionParser(expression, this.allowEscape);
            answer = parser.parseExpression();
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        SimpleLanguage answer = new SimpleLanguage();
        Expression exp = answer.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression(exp, resultType);
        }
        return exp;
    }

    public static void changeFunctionStartToken(String ... startToken) {
        SimpleTokenizer.changeFunctionStartToken(startToken);
    }

    public static void changeFunctionEndToken(String ... endToken) {
        SimpleTokenizer.changeFunctionEndToken(endToken);
    }

    public void setFunctionStartToken(String startToken) {
        SimpleLanguage.changeFunctionStartToken(startToken);
    }

    public void setFunctionEndToken(String endToken) {
        SimpleLanguage.changeFunctionEndToken(endToken);
    }
}

