/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;

public class PropertyPlaceholderDelegateRegistry
implements Registry {
    private final CamelContext context;
    private final Registry delegate;

    public PropertyPlaceholderDelegateRegistry(CamelContext context, Registry delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public Object lookup(String name) {
        try {
            if (!name.equals("properties")) {
                name = this.context.resolvePropertyPlaceholders(name);
            }
            return this.delegate.lookup(name);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        try {
            if (!name.equals("properties")) {
                name = this.context.resolvePropertyPlaceholders(name);
            }
            return this.delegate.lookup(name, type);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.delegate.lookupByType(type);
    }

    public Registry getRegistry() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

