/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.util.jsse.JsseParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagersParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(TrustManagersParameters.class);
    protected KeyStoreParameters keyStore;
    protected String provider;
    protected String algorithm;

    public TrustManager[] createTrustManagers() throws GeneralSecurityException, IOException {
        LOG.trace("Creating TrustManager[] from TrustManagersParameters [{}]", this);
        TrustManager[] trustManagers = null;
        if (this.getKeyStore() != null) {
            String tmfAlgorithm = this.parsePropertyValue(this.getAlgorithm());
            if (tmfAlgorithm == null) {
                tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            TrustManagerFactory tmf = this.getProvider() == null ? TrustManagerFactory.getInstance(tmfAlgorithm) : TrustManagerFactory.getInstance(tmfAlgorithm, this.parsePropertyValue(this.getProvider()));
            LOG.debug("TrustManagerFactory [{}] is using provider [{}] and algorithm [{}].", new Object[]{tmf, tmf.getProvider(), tmf.getAlgorithm()});
            KeyStore ks = this.getKeyStore() == null ? null : this.getKeyStore().createKeyStore();
            tmf.init(ks);
            trustManagers = tmf.getTrustManagers();
            LOG.debug("TrustManager[] [{}], initialized from TrustManagerFactory [{}].", trustManagers, (Object)tmf);
        }
        return trustManagers;
    }

    public KeyStoreParameters getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStoreParameters value) {
        this.keyStore = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String value) {
        this.algorithm = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TrustManagerType [keyStore=");
        builder.append(this.keyStore);
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", algorithm=");
        builder.append(this.algorithm);
        builder.append(", getContext()=");
        builder.append(this.getCamelContext());
        builder.append("]");
        return builder.toString();
    }
}

