/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.management.mbean.ManagedBeanProcessor;
import org.apache.camel.management.mbean.ManagedBrowsableEndpoint;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedDelayer;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedErrorHandler;
import org.apache.camel.management.mbean.ManagedEventNotifier;
import org.apache.camel.management.mbean.ManagedIdempotentConsumer;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedScheduledPollConsumer;
import org.apache.camel.management.mbean.ManagedSendProcessor;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedSuspendableRoute;
import org.apache.camel.management.mbean.ManagedThreadPool;
import org.apache.camel.management.mbean.ManagedThrottler;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Delayer;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementAware;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.RouteContext;

public class DefaultManagementObjectStrategy
implements ManagementObjectStrategy {
    @Override
    public Object getManagedObjectForCamelContext(CamelContext context) {
        ManagedCamelContext mc = new ManagedCamelContext((ModelCamelContext)context);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    @Override
    public Object getManagedObjectForComponent(CamelContext context, Component component, String name) {
        if (component instanceof ManagementAware) {
            return ((ManagementAware)((Object)component)).getManagedObject(component);
        }
        ManagedComponent mc = new ManagedComponent(name, component);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    @Override
    public Object getManagedObjectForEndpoint(CamelContext context, Endpoint endpoint) {
        if (!endpoint.isSingleton()) {
            return null;
        }
        if (endpoint instanceof ManagementAware) {
            return ((ManagementAware)((Object)endpoint)).getManagedObject(endpoint);
        }
        if (endpoint instanceof BrowsableEndpoint) {
            ManagedBrowsableEndpoint me = new ManagedBrowsableEndpoint((BrowsableEndpoint)endpoint);
            me.init(context.getManagementStrategy());
            return me;
        }
        ManagedEndpoint me = new ManagedEndpoint(endpoint);
        me.init(context.getManagementStrategy());
        return me;
    }

    @Override
    public Object getManagedObjectForErrorHandler(CamelContext context, RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
        ManagedErrorHandler me = new ManagedErrorHandler(routeContext, errorHandler, errorHandlerBuilder);
        me.init(context.getManagementStrategy());
        return me;
    }

    @Override
    public Object getManagedObjectForRoute(CamelContext context, Route route) {
        ManagedRoute mr = route.supportsSuspension() ? new ManagedSuspendableRoute((ModelCamelContext)context, route) : new ManagedRoute((ModelCamelContext)context, route);
        mr.init(context.getManagementStrategy());
        return mr;
    }

    @Override
    public Object getManagedObjectForThreadPool(CamelContext context, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        ManagedThreadPool mtp = new ManagedThreadPool(context, threadPool, id, sourceId, routeId, threadPoolProfileId);
        mtp.init(context.getManagementStrategy());
        return mtp;
    }

    @Override
    public Object getManagedObjectForEventNotifier(CamelContext context, EventNotifier eventNotifier) {
        ManagedEventNotifier men = new ManagedEventNotifier(context, eventNotifier);
        men.init(context.getManagementStrategy());
        return men;
    }

    @Override
    public Object getManagedObjectForConsumer(CamelContext context, Consumer consumer) {
        ManagedConsumer mc = consumer instanceof ScheduledPollConsumer ? new ManagedScheduledPollConsumer(context, (ScheduledPollConsumer)consumer) : new ManagedConsumer(context, consumer);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    @Override
    public Object getManagedObjectForProducer(CamelContext context, Producer producer) {
        ManagedProducer mp = new ManagedProducer(context, producer);
        mp.init(context.getManagementStrategy());
        return mp;
    }

    @Override
    public Object getManagedObjectForService(CamelContext context, Service service) {
        ManagedService mc = new ManagedService(context, service);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    @Override
    public Object getManagedObjectForProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition, Route route) {
        ManagedProcessor answer = null;
        Processor target = processor;
        while (target != null) {
            if (target instanceof ErrorHandler) {
                return false;
            }
            if (target instanceof Delayer) {
                answer = new ManagedDelayer(context, (Delayer)target, definition);
            } else if (target instanceof Throttler) {
                answer = new ManagedThrottler(context, (Throttler)target, definition);
            } else if (target instanceof SendProcessor) {
                answer = new ManagedSendProcessor(context, (SendProcessor)target, definition);
            } else if (target instanceof BeanProcessor) {
                answer = new ManagedBeanProcessor(context, (BeanProcessor)target, definition);
            } else if (target instanceof IdempotentConsumer) {
                answer = new ManagedIdempotentConsumer(context, (IdempotentConsumer)target, definition);
            } else if (target instanceof ManagementAware) {
                return ((ManagementAware)((Object)target)).getManagedObject(processor);
            }
            if (answer != null || !(target instanceof DelegateProcessor)) break;
            target = ((DelegateProcessor)target).getProcessor();
        }
        if (answer == null) {
            answer = new ManagedProcessor(context, target, definition);
        }
        answer.setRoute(route);
        answer.init(context.getManagementStrategy());
        return answer;
    }
}

