/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.model.dataformat.C24IOContentType;
import org.apache.camel.model.dataformat.C24IODataFormat;
import org.apache.camel.model.dataformat.CastorDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.dataformat.GzipDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JibxDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.dataformat.PGPDataFormat;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.SoapJaxbDataFormat;
import org.apache.camel.model.dataformat.StringDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TidyMarkupDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.model.dataformat.XmlJsonDataFormat;
import org.apache.camel.model.dataformat.ZipDataFormat;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.w3c.dom.Node;

public class DataFormatClause<T extends ProcessorDefinition<?>> {
    private final T processorType;
    private final Operation operation;

    public DataFormatClause(T processorType, Operation operation) {
        this.processorType = processorType;
        this.operation = operation;
    }

    public T avro() {
        return this.dataFormat(new AvroDataFormat());
    }

    public T avro(Object schema) {
        AvroDataFormat dataFormat = new AvroDataFormat();
        dataFormat.setSchema(schema);
        return this.dataFormat(dataFormat);
    }

    public T avro(String instanceClassName) {
        return this.dataFormat(new AvroDataFormat(instanceClassName));
    }

    public T bindy(BindyType type, String ... packages) {
        BindyDataFormat bindy = new BindyDataFormat();
        bindy.setType(type);
        bindy.setPackages(packages);
        return this.dataFormat(bindy);
    }

    public T bindy(BindyType type, Class<?> classType) {
        BindyDataFormat bindy = new BindyDataFormat();
        bindy.setType(type);
        bindy.setClassType(classType);
        return this.dataFormat(bindy);
    }

    public T c24io() {
        return this.dataFormat(new C24IODataFormat());
    }

    public T c24io(Class<?> dataObjectType) {
        return this.dataFormat(new C24IODataFormat(dataObjectType));
    }

    public T c24io(Class<?> elementType, C24IOContentType contentType) {
        return this.dataFormat(new C24IODataFormat(elementType, contentType));
    }

    public T c24io(C24IOContentType contentType) {
        return this.dataFormat(new C24IODataFormat(contentType));
    }

    public T csv() {
        return this.dataFormat(new CsvDataFormat());
    }

    public T custom(String ref) {
        return this.dataFormat(new CustomDataFormat(ref));
    }

    public T castor() {
        return this.dataFormat(new CastorDataFormat());
    }

    public T castor(String mappingFile) {
        CastorDataFormat castor = new CastorDataFormat();
        castor.setMappingFile(mappingFile);
        return this.dataFormat(castor);
    }

    public T castor(String mappingFile, boolean validation) {
        CastorDataFormat castor = new CastorDataFormat();
        castor.setMappingFile(mappingFile);
        castor.setValidation(validation);
        return this.dataFormat(castor);
    }

    public T gzip() {
        GzipDataFormat gzdf = new GzipDataFormat();
        return this.dataFormat(gzdf);
    }

    public T hl7() {
        return this.dataFormat(new HL7DataFormat());
    }

    public T hl7(boolean validate) {
        HL7DataFormat hl7 = new HL7DataFormat();
        hl7.setValidate(validate);
        return this.dataFormat(hl7);
    }

    public T pgp(String keyFileName, String keyUserid) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        return this.dataFormat(pgp);
    }

    public T pgp(String keyFileName, String keyUserid, String password) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        pgp.setPassword(password);
        return this.dataFormat(pgp);
    }

    public T pgp(String keyFileName, String keyUserid, String password, boolean armored, boolean integrity) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        pgp.setPassword(password);
        pgp.setArmored(armored);
        pgp.setIntegrity(integrity);
        return this.dataFormat(pgp);
    }

    public T jaxb() {
        return this.dataFormat(new JaxbDataFormat());
    }

    public T jaxb(String contextPath) {
        JaxbDataFormat dataFormat = new JaxbDataFormat();
        dataFormat.setContextPath(contextPath);
        return this.dataFormat(dataFormat);
    }

    public T jaxb(boolean prettyPrint) {
        return this.dataFormat(new JaxbDataFormat(prettyPrint));
    }

    public T jibx() {
        return this.dataFormat(new JibxDataFormat());
    }

    public T jibx(Class<?> unmarshallClass) {
        return this.dataFormat(new JibxDataFormat(unmarshallClass));
    }

    public T json() {
        return this.dataFormat(new JsonDataFormat());
    }

    public T json(JsonLibrary library) {
        return this.dataFormat(new JsonDataFormat(library));
    }

    public T json(JsonLibrary type, Class<?> unmarshalType) {
        JsonDataFormat json = new JsonDataFormat(type);
        json.setUnmarshalType(unmarshalType);
        return this.dataFormat(json);
    }

    public T protobuf() {
        return this.dataFormat(new ProtobufDataFormat());
    }

    public T protobuf(Object defaultInstance) {
        ProtobufDataFormat dataFormat = new ProtobufDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        return this.dataFormat(dataFormat);
    }

    public T protobuf(String instanceClassName) {
        return this.dataFormat(new ProtobufDataFormat(instanceClassName));
    }

    public T rss() {
        return this.dataFormat(new RssDataFormat());
    }

    public T serialization() {
        return this.dataFormat(new SerializationDataFormat());
    }

    public T soapjaxb() {
        return this.dataFormat(new SoapJaxbDataFormat());
    }

    public T soapjaxb(String contextPath) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath));
    }

    public T soapjaxb(String contextPath, String elementNameStrategyRef) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath, elementNameStrategyRef));
    }

    public T soapjaxb(String contextPath, Object elementNameStrategy) {
        return this.dataFormat(new SoapJaxbDataFormat(contextPath, elementNameStrategy));
    }

    public T soapjaxb12() {
        SoapJaxbDataFormat soap = new SoapJaxbDataFormat();
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soapjaxb12(String contextPath) {
        SoapJaxbDataFormat soap = new SoapJaxbDataFormat(contextPath);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soapjaxb12(String contextPath, String elementNameStrategyRef) {
        SoapJaxbDataFormat soap = new SoapJaxbDataFormat(contextPath, elementNameStrategyRef);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soapjaxb12(String contextPath, Object elementNameStrategy) {
        SoapJaxbDataFormat soap = new SoapJaxbDataFormat(contextPath, elementNameStrategy);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T string() {
        return this.string(null);
    }

    public T string(String charset) {
        StringDataFormat sdf = new StringDataFormat();
        sdf.setCharset(charset);
        return this.dataFormat(sdf);
    }

    public T syslog() {
        return this.dataFormat(new SyslogDataFormat());
    }

    public T tidyMarkup(Class<?> dataObjectType) {
        return this.dataFormat(new TidyMarkupDataFormat(dataObjectType));
    }

    public T tidyMarkup() {
        return this.dataFormat(new TidyMarkupDataFormat(Node.class));
    }

    public T xstream() {
        return this.dataFormat(new XStreamDataFormat());
    }

    public T xstream(String encoding) {
        return this.dataFormat(new XStreamDataFormat(encoding));
    }

    public T secureXML() {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String passPhrase) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, passPhrase);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, passPhrase);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, passPhrase, xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, passPhrase, xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    @Deprecated
    public T secureXML(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParametersId);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParametersId, keyPassword);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParameters);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParameters, keyPassword);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParametersId);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParametersId, keyPassword);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParameters);
        return this.dataFormat(xsdf);
    }

    public T secureXML(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat(secureTag, namespaces, secureTagContents, recipientKeyAlias, xmlCipherAlgorithm, keyCipherAlgorithm, keyOrTrustStoreParameters, keyPassword);
        return this.dataFormat(xsdf);
    }

    public T xmlBeans() {
        return this.dataFormat(new XMLBeansDataFormat());
    }

    public T xmljson() {
        return this.dataFormat(new XmlJsonDataFormat());
    }

    public T xmljson(Map<String, String> options) {
        return this.dataFormat(new XmlJsonDataFormat(options));
    }

    public T zip() {
        ZipDataFormat zdf = new ZipDataFormat(-1);
        return this.dataFormat(zdf);
    }

    public T zip(int compressionLevel) {
        ZipDataFormat zdf = new ZipDataFormat(compressionLevel);
        return this.dataFormat(zdf);
    }

    private T dataFormat(DataFormatDefinition dataFormatType) {
        switch (this.operation) {
            case Unmarshal: {
                return (T)((ProcessorDefinition)this.processorType).unmarshal(dataFormatType);
            }
            case Marshal: {
                return (T)((ProcessorDefinition)this.processorType).marshal(dataFormatType);
            }
        }
        throw new IllegalArgumentException("Unknown DataFormat operation: " + (Object)((Object)this.operation));
    }

    public static enum Operation {
        Marshal,
        Unmarshal;

    }
}

