/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.iq80.snappy.Snappy;

public class SnappyDecompressor
implements Processor {
    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        if (in.getBody() != null) {
            byte[] data = in.getMandatoryBody(byte[].class);
            byte[] uncompressed = Snappy.uncompress(data, 0, data.length);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFrom(in);
                out.setBody(uncompressed);
            } else {
                in.setBody(uncompressed);
            }
        }
    }
}

