/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertBodyProcessor
extends ServiceSupport
implements Processor {
    private final Class<?> type;
    private final String charset;

    public ConvertBodyProcessor(Class<?> type) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = null;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
    }

    public String toString() {
        return "convertBodyTo[" + this.type.getCanonicalName() + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return;
        }
        if (this.charset != null) {
            exchange.setProperty("CamelCharsetName", this.charset);
        }
        Object value = in.getMandatoryBody(this.type);
        DefaultMessage msg = new DefaultMessage();
        msg.copyFrom(in);
        msg.setBody(value);
        if (exchange.getPattern().isOutCapable()) {
            exchange.setOut(msg);
        } else {
            exchange.setIn(msg);
        }
        if (this.charset != null) {
            exchange.removeProperty("CamelCharsetName");
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

