/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.core.xml.AbstractCamelEndpointFactoryBean;
import org.apache.camel.core.xml.AbstractCamelRedeliveryPolicyFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.PatternBasedPackageScanFilter;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelContextFactoryBean<T extends ModelCamelContext>
extends IdentifiedType
implements RouteContainer {
    public static final String LAZY_LOAD_TYPE_CONVERTERS = "CamelLazyLoadTypeConverters";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContextFactoryBean.class);
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();

    public T getObject() throws Exception {
        return this.getContext();
    }

    public abstract Class<T> getObjectType();

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, LifecycleStrategy> lifecycleStrategies;
        Map<String, InterceptStrategy> interceptStrategies;
        ShutdownStrategy shutdownStrategy;
        Map<String, EndpointStrategy> endpointStrategies;
        Map<String, EventNotifier> eventNotifiers;
        EventFactory eventFactory;
        ManagementNamingStrategy managementNamingStrategy;
        ManagementStrategy managementStrategy;
        InflightRepository inflightRepository;
        Delayer delayer;
        HandleFault handleFault;
        if (ObjectHelper.isEmpty(this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        PackageScanClassResolver packageResolver = this.getBeanForType(PackageScanClassResolver.class);
        if (packageResolver != null) {
            LOG.info("Using custom PackageScanClassResolver: " + packageResolver);
            this.getContext().setPackageScanClassResolver(packageResolver);
        }
        if (this.getProperties() != null) {
            this.getContext().setProperties(this.getProperties().asMap());
        }
        this.initLazyLoadTypeConverteres();
        this.setupCustomServices();
        this.initCustomRegistry(this.getContext());
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        Tracer tracer = this.getBeanForType(Tracer.class);
        if (tracer != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info("Using custom Tracer: " + tracer);
            this.getContext().addInterceptStrategy(tracer);
        }
        if ((handleFault = this.getBeanForType(HandleFault.class)) != null) {
            LOG.info("Using custom HandleFault: " + handleFault);
            this.getContext().addInterceptStrategy(handleFault);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            LOG.info("Using custom Delayer: " + delayer);
            this.getContext().addInterceptStrategy(delayer);
        }
        if ((inflightRepository = this.getBeanForType(InflightRepository.class)) != null) {
            LOG.info("Using custom InflightRepository: " + inflightRepository);
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info("Using custom ManagementStrategy: " + managementStrategy);
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((managementNamingStrategy = this.getBeanForType(ManagementNamingStrategy.class)) != null) {
            LOG.info("Using custom ManagementNamingStrategy: " + managementNamingStrategy);
            this.getContext().getManagementStrategy().setManagementNamingStrategy(managementNamingStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info("Using custom EventFactory: " + eventFactory);
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((eventNotifiers = this.getContext().getRegistry().lookupByType(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry<String, EventNotifier> entry : eventNotifiers.entrySet()) {
                EventNotifier notifier = entry.getValue();
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(notifier)) continue;
                LOG.info("Using custom EventNotifier with id: " + entry.getKey() + " and implementation: " + notifier);
                this.getContext().getManagementStrategy().addEventNotifier(notifier);
            }
        }
        if ((endpointStrategies = this.getContext().getRegistry().lookupByType(EndpointStrategy.class)) != null && !endpointStrategies.isEmpty()) {
            for (Map.Entry<String, EndpointStrategy> entry : endpointStrategies.entrySet()) {
                EndpointStrategy strategy = entry.getValue();
                LOG.info("Using custom EndpointStrategy with id: " + entry.getKey() + " and implementation: " + strategy);
                this.getContext().addRegisterEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info("Using custom ShutdownStrategy: " + shutdownStrategy);
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((interceptStrategies = this.getContext().getRegistry().lookupByType(InterceptStrategy.class)) != null && !interceptStrategies.isEmpty()) {
            for (Map.Entry<String, InterceptStrategy> entry : interceptStrategies.entrySet()) {
                InterceptStrategy strategy = entry.getValue();
                if (this.getContext().getInterceptStrategies().contains(strategy)) continue;
                LOG.info("Using custom InterceptStrategy with id: " + entry.getKey() + " and implementation: " + strategy);
                this.getContext().addInterceptStrategy(strategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().lookupByType(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry<String, LifecycleStrategy> entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy strategy = entry.getValue();
                if (this.getContext().getLifecycleStrategies().contains(strategy)) continue;
                LOG.info("Using custom LifecycleStrategy with id: " + entry.getKey() + " and implementation: " + strategy);
                this.getContext().addLifecycleStrategy(strategy);
            }
        }
        this.initThreadPoolProfiles(this.getContext());
        this.initBeanPostProcessor(this.getContext());
        this.initCamelContext(this.getContext());
        this.initRouteRefs();
        this.prepareRoutes();
        this.getContext().addRouteDefinitions(this.getRoutes());
        LOG.debug("Found JAXB created routes: {}", this.getRoutes());
        this.findRouteBuilders();
        this.installRoutes();
    }

    private void prepareRoutes() {
        for (RouteDefinition route : this.getRoutes()) {
            RouteDefinitionHelper.sanityCheckRoute(route);
            RouteDefinitionHelper.prepareRoute(this.getContext(), route, this.getOnExceptions(), this.getIntercepts(), this.getInterceptFroms(), this.getInterceptSendToEndpoints(), this.getOnCompletions());
            route.markPrepared();
        }
    }

    protected abstract void initCustomRegistry(T var1);

    protected void initLazyLoadTypeConverteres() {
        if (this.getLazyLoadTypeConverters() != null) {
            this.getContext().setLazyLoadTypeConverters(this.getLazyLoadTypeConverters());
        } else if (System.getProperty(LAZY_LOAD_TYPE_CONVERTERS) != null) {
            String lazy = System.getProperty(LAZY_LOAD_TYPE_CONVERTERS);
            if ("true".equalsIgnoreCase(lazy)) {
                this.getContext().setLazyLoadTypeConverters(true);
            } else if ("false".equalsIgnoreCase(lazy)) {
                this.getContext().setLazyLoadTypeConverters(false);
            } else {
                throw new IllegalArgumentException("System property with key CamelLazyLoadTypeConverters has unknown value: " + lazy);
            }
        }
    }

    protected void initJMXAgent() throws Exception {
        CamelJMXAgentDefinition camelJMXAgent = this.getCamelJMXAgent();
        boolean disabled = false;
        if (camelJMXAgent != null) {
            disabled = CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getDisabled());
        }
        if (disabled) {
            LOG.info("JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy(new DefaultManagementStrategy());
        } else if (camelJMXAgent != null) {
            LOG.info("JMXAgent enabled: " + camelJMXAgent);
            DefaultManagementAgent agent = new DefaultManagementAgent((CamelContext)this.getContext());
            agent.setConnectorPort(CamelContextHelper.parseInteger(this.getContext(), camelJMXAgent.getConnectorPort()));
            agent.setCreateConnector(CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getCreateConnector()));
            agent.setMBeanObjectDomainName(CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getMbeanObjectDomainName()));
            agent.setMBeanServerDefaultDomain(CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getMbeanServerDefaultDomain()));
            agent.setRegistryPort(CamelContextHelper.parseInteger(this.getContext(), camelJMXAgent.getRegistryPort()));
            agent.setServiceUrlPath(CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getServiceUrlPath()));
            agent.setUsePlatformMBeanServer(CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getUsePlatformMBeanServer()));
            agent.setOnlyRegisterProcessorWithCustomId(CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            agent.setRegisterAlways(CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getRegisterAlways()));
            agent.setRegisterNewRoutes(CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getRegisterNewRoutes()));
            ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy((CamelContext)this.getContext(), agent);
            this.getContext().setManagementStrategy(managementStrategy);
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().addLifecycleStrategy(new DefaultManagementLifecycleStrategy((CamelContext)this.getContext()));
            boolean onlyId = agent.getOnlyRegisterProcessorWithCustomId() != null && agent.getOnlyRegisterProcessorWithCustomId() != false;
            this.getContext().getManagementStrategy().onlyManageProcessorWithCustomId(onlyId);
            this.getContext().getManagementStrategy().setStatisticsLevel(camelJMXAgent.getStatisticsLevel());
        }
    }

    protected void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            PropertiesComponent pc = new PropertiesComponent();
            pc.setLocation(def.getLocation());
            if (def.isCache() != null) {
                pc.setCache(def.isCache());
            }
            if (def.isIgnoreMissingLocation() != null) {
                pc.setIgnoreMissingLocation(def.isIgnoreMissingLocation());
            }
            if (ObjectHelper.isNotEmpty(def.getPropertiesResolverRef())) {
                PropertiesResolver resolver = CamelContextHelper.mandatoryLookup(this.getContext(), def.getPropertiesResolverRef(), PropertiesResolver.class);
                pc.setPropertiesResolver(resolver);
            }
            if (ObjectHelper.isNotEmpty(def.getPropertiesParserRef())) {
                PropertiesParser parser = CamelContextHelper.mandatoryLookup(this.getContext(), def.getPropertiesParserRef(), PropertiesParser.class);
                pc.setPropertiesParser(parser);
            }
            pc.setPropertyPrefix(def.getPropertyPrefix());
            pc.setPropertySuffix(def.getPropertySuffix());
            if (def.isFallbackToUnaugmentedProperty() != null) {
                pc.setFallbackToUnaugmentedProperty(def.isFallbackToUnaugmentedProperty());
            }
            pc.setPrefixToken(def.getPrefixToken());
            pc.setSuffixToken(def.getSuffixToken());
            this.getContext().addComponent("properties", pc);
        }
    }

    protected void initRouteRefs() throws Exception {
        if (this.getRouteRefs() != null) {
            for (RouteContextRefDefinition ref : this.getRouteRefs()) {
                List<RouteDefinition> defs = ref.lookupRoutes((CamelContext)this.getContext());
                for (RouteDefinition def : defs) {
                    LOG.debug("Adding route from {} -> {}", ref, (Object)def);
                    this.getRoutes().add(0, def);
                }
            }
        }
    }

    protected abstract <S> S getBeanForType(Class<S> var1);

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public T getContext() {
        return this.getContext(true);
    }

    public abstract T getContext(boolean var1);

    @Override
    public abstract List<RouteDefinition> getRoutes();

    public abstract List<? extends AbstractCamelEndpointFactoryBean> getEndpoints();

    public abstract List<? extends AbstractCamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies();

    public abstract List<InterceptDefinition> getIntercepts();

    public abstract List<InterceptFromDefinition> getInterceptFroms();

    public abstract List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints();

    public abstract PropertiesDefinition getProperties();

    public abstract String[] getPackages();

    public abstract PackageScanDefinition getPackageScan();

    public abstract void setPackageScan(PackageScanDefinition var1);

    public abstract ContextScanDefinition getContextScan();

    public abstract void setContextScan(ContextScanDefinition var1);

    public abstract CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder();

    public abstract String getTrace();

    public abstract String getStreamCache();

    public abstract String getDelayer();

    public abstract String getHandleFault();

    public abstract String getAutoStartup();

    public abstract String getUseMDCLogging();

    public abstract String getUseBreadcrumb();

    public abstract String getManagementNamePattern();

    @Deprecated
    public abstract Boolean getLazyLoadTypeConverters();

    public abstract CamelJMXAgentDefinition getCamelJMXAgent();

    public abstract List<RouteBuilderDefinition> getBuilderRefs();

    public abstract List<RouteContextRefDefinition> getRouteRefs();

    public abstract String getErrorHandlerRef();

    public abstract DataFormatsDefinition getDataFormats();

    public abstract List<OnExceptionDefinition> getOnExceptions();

    public abstract List<OnCompletionDefinition> getOnCompletions();

    public abstract ShutdownRoute getShutdownRoute();

    public abstract ShutdownRunningTask getShutdownRunningTask();

    public abstract List<ThreadPoolProfileDefinition> getThreadPoolProfiles();

    public abstract String getDependsOn();

    protected void initCamelContext(T ctx) throws Exception {
        if (this.getStreamCache() != null) {
            ctx.setStreamCaching(CamelContextHelper.parseBoolean(this.getContext(), this.getStreamCache()));
        }
        if (this.getTrace() != null) {
            ctx.setTracing(CamelContextHelper.parseBoolean(this.getContext(), this.getTrace()));
        }
        if (this.getDelayer() != null) {
            ctx.setDelayer(CamelContextHelper.parseLong(this.getContext(), this.getDelayer()));
        }
        if (this.getHandleFault() != null) {
            ctx.setHandleFault(CamelContextHelper.parseBoolean(this.getContext(), this.getHandleFault()));
        }
        if (this.getErrorHandlerRef() != null) {
            ctx.setErrorHandlerBuilder(new ErrorHandlerBuilderRef(this.getErrorHandlerRef()));
        }
        if (this.getAutoStartup() != null) {
            ctx.setAutoStartup(CamelContextHelper.parseBoolean(this.getContext(), this.getAutoStartup()));
        }
        if (this.getUseMDCLogging() != null) {
            ctx.setUseMDCLogging(CamelContextHelper.parseBoolean(this.getContext(), this.getUseMDCLogging()));
        }
        if (this.getUseBreadcrumb() != null) {
            ctx.setUseBreadcrumb(CamelContextHelper.parseBoolean(this.getContext(), this.getUseBreadcrumb()));
        }
        if (this.getManagementNamePattern() != null) {
            ctx.getManagementNameStrategy().setNamePattern(this.getManagementNamePattern());
        }
        if (this.getShutdownRoute() != null) {
            ctx.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.getShutdownRunningTask() != null) {
            ctx.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        if (this.getDataFormats() != null) {
            ctx.setDataFormats(this.getDataFormats().asMap());
        }
    }

    protected void initThreadPoolProfiles(T context) throws Exception {
        HashSet<String> defaultIds = new HashSet<String>();
        Map<String, ThreadPoolProfile> profiles = context.getRegistry().lookupByType(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry<String, ThreadPoolProfile> entry : profiles.entrySet()) {
                ThreadPoolProfile profile = entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: " + entry.getKey() + " and implementation: " + profile);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (this.getThreadPoolProfiles() != null && !this.getThreadPoolProfiles().isEmpty()) {
            for (ThreadPoolProfileDefinition definition : this.getThreadPoolProfiles()) {
                if (definition.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: " + definition.getId() + " and implementation: " + definition);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
                    defaultIds.add(definition.getId());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private ThreadPoolProfile asThreadPoolProfile(CamelContext context, ThreadPoolProfileDefinition definition) throws Exception {
        ThreadPoolProfile answer = new ThreadPoolProfile();
        answer.setId(definition.getId());
        answer.setDefaultProfile(definition.getDefaultProfile());
        answer.setPoolSize(CamelContextHelper.parseInteger(context, definition.getPoolSize()));
        answer.setMaxPoolSize(CamelContextHelper.parseInteger(context, definition.getMaxPoolSize()));
        answer.setKeepAliveTime(CamelContextHelper.parseLong(context, definition.getKeepAliveTime()));
        answer.setMaxQueueSize(CamelContextHelper.parseInteger(context, definition.getMaxQueueSize()));
        answer.setRejectedPolicy(definition.getRejectedPolicy());
        answer.setTimeUnit(definition.getTimeUnit());
        return answer;
    }

    protected abstract void initBeanPostProcessor(T var1);

    protected void installRoutes() throws Exception {
        ArrayList<RouteBuilder> builders = new ArrayList<RouteBuilder>();
        if (this.getBuilderRefs() != null) {
            for (RouteBuilderDefinition builderRef : this.getBuilderRefs()) {
                RouteBuilder builder = builderRef.createRouteBuilder((CamelContext)this.getContext());
                if (builder != null) {
                    builders.add(builder);
                    continue;
                }
                RoutesBuilder routes = builderRef.createRoutes((CamelContext)this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            this.postProcessBeforeInit(builder);
            this.getContext().addRoutes(builder);
        }
    }

    protected abstract void postProcessBeforeInit(RouteBuilder var1);

    protected void findRouteBuilders() throws Exception {
        ContextScanDefinition contextScanDef;
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : packageScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : packageScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            String[] normalized = this.normalizePackages(this.getContext(), packageScanDef.getPackages());
            this.findRouteBuildersByPackageScan(normalized, filter, this.builders);
        }
        if ((contextScanDef = this.getContextScan()) != null) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : contextScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : contextScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            this.findRouteBuildersByContextScan(filter, this.builders);
        }
    }

    protected abstract void findRouteBuildersByPackageScan(String[] var1, PackageScanFilter var2, List<RoutesBuilder> var3) throws Exception;

    protected abstract void findRouteBuildersByContextScan(PackageScanFilter var1, List<RoutesBuilder> var2) throws Exception;

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(T context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!ObjectHelper.isNotEmpty(name = ObjectHelper.normalizeClassName(name))) continue;
            LOG.trace("Using package: {} to scan for RouteBuilder classes", (Object)name);
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private void setupCustomServices() {
        NodeIdFactory nodeIdFactory;
        UuidGenerator uuidGenerator;
        Debugger debugger;
        ProcessorFactory processorFactory;
        ThreadPoolFactory threadPoolFactory;
        ExecutorServiceManager executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver = this.getBeanForType(ClassResolver.class);
        if (classResolver != null) {
            LOG.info("Using custom ClassResolver: " + classResolver);
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info("Using custom FactoryFinderResolver: " + factoryFinderResolver);
            this.getContext().setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceManager.class)) != null) {
            LOG.info("Using custom ExecutorServiceStrategy: " + executorServiceStrategy);
            this.getContext().setExecutorServiceManager(executorServiceStrategy);
        }
        if ((threadPoolFactory = this.getBeanForType(ThreadPoolFactory.class)) != null) {
            LOG.info("Using custom ThreadPoolFactory: " + threadPoolFactory);
            this.getContext().getExecutorServiceManager().setThreadPoolFactory(threadPoolFactory);
        }
        if ((processorFactory = this.getBeanForType(ProcessorFactory.class)) != null) {
            LOG.info("Using custom ProcessorFactory: " + processorFactory);
            this.getContext().setProcessorFactory(processorFactory);
        }
        if ((debugger = this.getBeanForType(Debugger.class)) != null) {
            LOG.info("Using custom Debugger: " + debugger);
            this.getContext().setDebugger(debugger);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: " + uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((nodeIdFactory = this.getBeanForType(NodeIdFactory.class)) != null) {
            LOG.info("Using custom NodeIdFactory: " + nodeIdFactory);
            this.getContext().setNodeIdFactory(nodeIdFactory);
        }
    }
}

