/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    protected boolean runningAllowed() {
        return this.endpoint.isRunning();
    }

    @Override
    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName;
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String string = beanName = this.getBeanName() == null ? this.endpoint.getThreadName() : this.getBeanName();
        if (this.endpoint.getDefaultTaskExecutorType() == DefaultTaskExecutorType.ThreadPool) {
            ThreadPoolTaskExecutor answer = new ThreadPoolTaskExecutor();
            answer.setBeanName(beanName);
            answer.setThreadFactory(new CamelThreadFactory(pattern, beanName, true));
            answer.setCorePoolSize(this.endpoint.getConcurrentConsumers());
            answer.setQueueCapacity(0);
            answer.initialize();
            return answer;
        }
        SimpleAsyncTaskExecutor answer = new SimpleAsyncTaskExecutor(beanName);
        answer.setThreadFactory(new CamelThreadFactory(pattern, beanName, true));
        return answer;
    }
}

