/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Service;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class LRUCache<K, V>
implements Service,
Map<K, V> {
    private static final long serialVersionUID = -342098639681884414L;
    private int maxCacheSize = 10000;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private ConcurrentLinkedHashMap<K, V> map;

    public LRUCache(int maximumCacheSize) {
        this(maximumCacheSize, maximumCacheSize);
    }

    public LRUCache(int initialCapacity, int maximumCacheSize) {
        this.map = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maximumCacheSize).build();
        this.maxCacheSize = maximumCacheSize;
    }

    @Override
    public V get(Object o) {
        V answer = this.map.get(o);
        if (answer != null) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        return answer;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(0);
    }

    @Override
    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        ((AbstractMap)map).putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.ascendingKeySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.ascendingMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.ascendingMap().entrySet();
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.map.size() > this.maxCacheSize;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (!this.isEmpty()) {
            ServiceHelper.stopServices(this.values());
            this.map.clear();
            this.hits.set(0L);
            this.misses.set(0L);
        }
    }

    public String toString() {
        return "LRUCache@" + ObjectHelper.getIdentityHashCode(this);
    }
}

