/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(IOHelper.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private IOHelper() {
    }

    public static String newStringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"utf-8\") returns invalid name.", e);
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start, int length) {
        try {
            return new String(bytes, start, length, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"utf-8\") returns invalid name.", e);
        }
    }

    @Deprecated
    public static IOException createIOException(Throwable cause) {
        return IOHelper.createIOException(cause.getMessage(), cause);
    }

    @Deprecated
    public static IOException createIOException(String message, Throwable cause) {
        IOException answer = new IOException(message);
        answer.initCause(cause);
        return answer;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOHelper.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        IOHelper.copy(input, output);
        IOHelper.close(input, null, LOG);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        IOHelper.copy(input, output, bufferSize);
        IOHelper.close(input, null, LOG);
    }

    public static void close(Closeable closeable, String name, Logger log) {
        block4: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null) break block4;
                    if (name != null) {
                        log.warn("Cannot close: " + name + ". Reason: " + e.getMessage(), e);
                    }
                    log.warn("Cannot close. Reason: " + e.getMessage(), e);
                }
            }
        }
    }

    public static void close(Closeable closeable, String name) {
        IOHelper.close(closeable, name, LOG);
    }

    public static void close(Closeable closeable) {
        IOHelper.close(closeable, null, LOG);
    }
}

