/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventHelper.class);

    private EventHelper() {
    }

    public static void notifyCamelContextStarting(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStartingEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextStarted(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStartedEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextStartupFailed(CamelContext context, Throwable cause) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStartupFailureEvent(context, cause);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextStopping(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) {
                return;
            }
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStoppingEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextStopped(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStoppedEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextStopFailed(CamelContext context, Throwable cause) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextStopFailureEvent(context, cause);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyServiceStopFailure(CamelContext context, Object service, Throwable cause) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreServiceEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createServiceStopFailureEvent(context, service, cause);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyServiceStartupFailure(CamelContext context, Object service, Throwable cause) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreServiceEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createServiceStartupFailureEvent(context, service, cause);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyRouteStarted(CamelContext context, Route route) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreRouteEvents()) {
                return;
            }
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createRouteStartedEvent(route);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyRouteStopped(CamelContext context, Route route) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreRouteEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createRouteStoppedEvent(route);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeCreated(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCreatedEvent()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeCreatedEvent(exchange);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeDone(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCompletedEvent()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeCompletedEvent(exchange);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeFailed(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeFailedEvent(exchange);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeFailureHandled(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeFailureHandledEvent(exchange, failureHandler, deadLetterChannel);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeRedelivery(CamelContext context, Exchange exchange, int attempt) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeRedeliveryEvent(exchange, attempt);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyExchangeSent(CamelContext context, Exchange exchange, Endpoint endpoint, long timeTaken) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return;
        }
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSentEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createExchangeSentEvent(exchange, endpoint, timeTaken);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextSuspending(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextSuspendingEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextSuspended(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextSuspendedEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextResuming(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextResumingEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextResumed(CamelContext context) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextResumedEvent(context);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    public static void notifyCamelContextResumeFailed(CamelContext context, Throwable cause) {
        List<EventNotifier> notifiers = context.getManagementStrategy().getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return;
        }
        for (EventNotifier notifier : notifiers) {
            if (notifier.isIgnoreCamelContextEvents()) continue;
            EventFactory factory = context.getManagementStrategy().getEventFactory();
            if (factory == null) {
                return;
            }
            EventObject event = factory.createCamelContextResumeFailureEvent(context, cause);
            if (event == null) {
                return;
            }
            EventHelper.doNotifyEvent(notifier, event);
        }
    }

    private static void doNotifyEvent(EventNotifier notifier, EventObject event) {
        boolean started = true;
        if (notifier instanceof ServiceSupport) {
            started = ((ServiceSupport)((Object)notifier)).isStarted();
        }
        if (!started) {
            LOG.debug("Ignoring notifying event {}. The EventNotifier has not been started yet: {}", event, (Object)notifier);
            return;
        }
        if (!notifier.isEnabled(event)) {
            LOG.trace("Notification of event is disabled: {}", event);
            return;
        }
        try {
            notifier.notify(event);
        }
        catch (Throwable e) {
            LOG.warn("Error notifying event " + event + ". This exception will be ignored. ", e);
        }
    }
}

