/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;

@XmlRootElement(name="secureXML")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLSecurityDataFormat
extends DataFormatDefinition {
    private static final transient String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    @XmlAttribute
    private String xmlCipherAlgorithm;
    @XmlAttribute
    private String passPhrase;
    @XmlAttribute
    private String secureTag;
    @XmlAttribute
    private Boolean secureTagContents;
    @XmlAttribute
    private String keyCipherAlgorithm;
    @XmlAttribute
    private String recipientKeyAlias;

    public XMLSecurityDataFormat() {
        super("secureXML");
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase) {
        this(secureTag, secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        this(secureTag, secureTagContents, passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.getSecureTag() != null) {
            this.setProperty(dataFormat, "secureTag", this.getSecureTag());
        } else {
            this.setProperty(dataFormat, "secureTag", "");
        }
        this.setProperty(dataFormat, "secureTagContents", this.isSecureTagContents());
        if (this.passPhrase != null) {
            this.setProperty(dataFormat, "passPhrase", this.getPassPhrase().getBytes());
        } else {
            this.setProperty(dataFormat, "passPhrase", "Just another 24 Byte key".getBytes());
        }
        if (this.getXmlCipherAlgorithm() != null) {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", this.getXmlCipherAlgorithm());
        } else {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", TRIPLEDES);
        }
        if (this.getKeyCipherAlgorithm() != null) {
            this.setProperty(dataFormat, "keyCipherAlgorithm", this.getKeyCipherAlgorithm());
        }
        if (this.getRecipientKeyAlias() != null) {
            this.setProperty(dataFormat, "recipientKeyAlias", this.getRecipientKeyAlias());
        }
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public Boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(Boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents != null && this.secureTagContents != false;
    }

    public void setKeyCipherAlgorithm(String keyCipherAlgorithm) {
        this.keyCipherAlgorithm = keyCipherAlgorithm;
    }

    public String getKeyCipherAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public void setRecipientKeyAlias(String recipientKeyAlias) {
        this.recipientKeyAlias = recipientKeyAlias;
    }

    public String getRecipientKeyAlias() {
        return this.recipientKeyAlias;
    }
}

