/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanDefinition
extends NoOutputDefinition<BeanDefinition> {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute
    private String beanType;
    @XmlTransient
    private Object bean;

    public BeanDefinition() {
    }

    public BeanDefinition(String ref) {
        this.ref = ref;
    }

    public BeanDefinition(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "bean";
    }

    public String getRef() {
        return this.ref;
    }

    @Required
    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public BeanDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public BeanDefinition method(String method) {
        this.setMethod(method);
        return this;
    }

    @Override
    public BeanDefinition bean(Object bean) {
        this.setBean(bean);
        return this;
    }

    public BeanDefinition beanType(Class<?> beanType) {
        this.setBean(beanType);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        BeanProcessor answer;
        if (ObjectHelper.isNotEmpty(this.ref)) {
            RegistryBean beanHolder = new RegistryBean(routeContext.getCamelContext(), this.ref);
            this.bean = beanHolder.getBean();
            answer = new BeanProcessor(beanHolder);
        } else {
            if (this.bean == null) {
                Class<?> clazz;
                ObjectHelper.notNull(this.beanType, "bean, ref or beanType", this);
                try {
                    clazz = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.beanType);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                this.bean = CamelContextHelper.newInstance(routeContext.getCamelContext(), clazz);
            }
            ObjectHelper.notNull(this.bean, "bean", this);
            if (this.bean instanceof String) {
                throw new IllegalArgumentException("The bean instance is a java.lang.String type: " + this.bean + ". We suppose you want to refer to a bean instance by its id instead. Please use beanRef.");
            }
            answer = new BeanProcessor(this.bean, routeContext.getCamelContext());
        }
        if (this.method != null) {
            answer.setMethod(this.method);
            BeanInfo info = new BeanInfo(routeContext.getCamelContext(), this.bean.getClass());
            if (!info.hasMethod(this.method)) {
                throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, this.bean, this.method));
            }
        }
        return answer;
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            String methodText = "";
            if (this.method != null) {
                methodText = " method: " + this.method;
            }
            return "ref:" + this.ref + methodText;
        }
        if (this.bean != null) {
            return this.bean.toString();
        }
        if (this.beanType != null) {
            return this.beanType;
        }
        return "";
    }
}

