/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.bean.BeanConverter;
import org.apache.camel.component.file.GenericFileConverter;
import org.apache.camel.converter.CamelConverter;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.StreamSourceConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.impl.converter.FutureTypeConverter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorePackageScanClassResolver
implements PackageScanClassResolver {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private final Set<Class<?>> converters = new LinkedHashSet();

    public CorePackageScanClassResolver() {
        this.converters.add(ObjectConverter.class);
        this.converters.add(CollectionConverter.class);
        this.converters.add(IOConverter.class);
        this.converters.add(NIOConverter.class);
        this.converters.add(StaxConverter.class);
        this.converters.add(DomConverter.class);
        this.converters.add(StreamSourceConverter.class);
        this.converters.add(XmlConverter.class);
        this.converters.add(CamelConverter.class);
        this.converters.add(StreamCacheConverter.class);
        this.converters.add(TimePatternConverter.class);
        this.converters.add(FutureTypeConverter.class);
        this.converters.add(BeanConverter.class);
        this.converters.add(GenericFileConverter.class);
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders.addAll(classLoaders);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(new LinkedHashSet<ClassLoader>(this.classLoaders));
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    @Override
    public Set<Class<?>> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        return this.converters;
    }

    @Override
    public Set<Class<?>> findAnnotated(Set<Class<? extends Annotation>> annotations, String ... packageNames) {
        return this.converters;
    }

    @Override
    public Set<Class<?>> findImplementations(Class<?> parent, String ... packageNames) {
        return null;
    }

    @Override
    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        return null;
    }

    @Override
    public void addFilter(PackageScanFilter filter) {
    }

    @Override
    public void removeFilter(PackageScanFilter filter) {
    }
}

