/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.ArrayTypeConverter;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.impl.converter.CoreTypeConverterLoader;
import org.apache.camel.impl.converter.EnumTypeConverter;
import org.apache.camel.impl.converter.FutureTypeConverter;
import org.apache.camel.impl.converter.PropertyEditorTypeConverter;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTypeConverterRegistry
extends ServiceSupport
implements TypeConverter,
TypeConverterRegistry {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<TypeMapping, TypeConverter> typeMappings = new ConcurrentHashMap<TypeMapping, TypeConverter>();
    protected final Map<TypeMapping, TypeMapping> misses = new ConcurrentHashMap<TypeMapping, TypeMapping>();
    protected final List<TypeConverterLoader> typeConverterLoaders = new ArrayList<TypeConverterLoader>();
    protected final List<FallbackTypeConverter> fallbackConverters = new ArrayList<FallbackTypeConverter>();
    protected final PackageScanClassResolver resolver;
    protected Injector injector;
    protected final FactoryFinder factoryFinder;
    protected final PropertyEditorTypeConverter propertyEditorTypeConverter = new PropertyEditorTypeConverter();

    public BaseTypeConverterRegistry(PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder) {
        this.resolver = resolver;
        this.injector = injector;
        this.factoryFinder = factoryFinder;
        this.typeConverterLoaders.add(new AnnotationTypeConverterLoader(resolver));
        this.addFallbackTypeConverter(new ToStringTypeConverter(), false);
        this.addFallbackTypeConverter(this.propertyEditorTypeConverter, false);
        this.addFallbackTypeConverter(new EnumTypeConverter(), true);
        this.addFallbackTypeConverter(new ArrayTypeConverter(), true);
        this.addFallbackTypeConverter(new FutureTypeConverter(this), false);
        this.addFallbackTypeConverter(new AsyncProcessorTypeConverter(), true);
    }

    public List<TypeConverterLoader> getTypeConverterLoaders() {
        return this.typeConverterLoaders;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Object answer;
        if (!this.isRunAllowed()) {
            throw new IllegalStateException(this + " is not started");
        }
        try {
            answer = this.doConvertTo(type, exchange, value);
        }
        catch (Exception e) {
            boolean execution;
            boolean bl = execution = ObjectHelper.getException(ExecutionException.class, e) != null || ObjectHelper.getException(CamelExecutionException.class, e) != null;
            if (execution) {
                throw ObjectHelper.wrapCamelExecutionException(exchange, e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Caused by: {}. Will ignore this and continue.", (Object)NoTypeConversionAvailableException.createMessage(value, type), (Object)e.getMessage());
            }
            return null;
        }
        if (answer == Void.TYPE) {
            return null;
        }
        return (T)answer;
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        Object answer;
        if (!this.isRunAllowed()) {
            throw new IllegalStateException(this + " is not started");
        }
        try {
            answer = this.doConvertTo(type, exchange, value);
        }
        catch (Exception e) {
            throw new NoTypeConversionAvailableException(value, type, e);
        }
        if (answer == Void.TYPE || value == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return (T)answer;
    }

    protected Object doConvertTo(Class type, Exchange exchange, Object value) {
        Class<?> primitiveType;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Converting {} -> {} with value: {}", new Object[]{value == null ? "null" : value.getClass().getCanonicalName(), type.getCanonicalName(), value});
        }
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        TypeMapping key = new TypeMapping(type, value.getClass());
        if (this.misses.containsKey(key)) {
            return Void.TYPE;
        }
        TypeConverter converter = this.getOrFindTypeConverter(type, value);
        if (converter != null) {
            this.log.trace("Using converter: {} to convert {}", converter, (Object)key);
            Object rc = converter.convertTo(type, exchange, value);
            if (rc != null) {
                return rc;
            }
        }
        for (FallbackTypeConverter fallback : this.fallbackConverters) {
            Object rc = fallback.getFallbackTypeConverter().convertTo(type, exchange, value);
            if (Void.TYPE.equals(rc)) {
                return Void.TYPE;
            }
            if (rc == null) continue;
            if (fallback.isCanPromote()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Promoting fallback type converter as a known type converter to convert from: {} to: {} for the fallback converter: {}", new Object[]{type.getCanonicalName(), value.getClass().getCanonicalName(), fallback.getFallbackTypeConverter()});
                }
                this.addTypeConverter(type, value.getClass(), fallback.getFallbackTypeConverter());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Fallback type converter {} converted type from: {} to: {}", new Object[]{fallback.getFallbackTypeConverter(), type.getCanonicalName(), value.getClass().getCanonicalName()});
            }
            return rc;
        }
        if (type.isPrimitive() && (primitiveType = ObjectHelper.convertPrimitiveTypeToWrapperType(type)) != type) {
            return this.convertTo(primitiveType, exchange, value);
        }
        this.misses.put(key, key);
        return Void.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypeConverter(Class<?> toType, Class<?> fromType, TypeConverter typeConverter) {
        this.log.trace("Adding type converter: {}", typeConverter);
        TypeMapping key = new TypeMapping(toType, fromType);
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            TypeConverter converter = this.typeMappings.get(key);
            if (typeConverter != converter) {
                if (converter != null) {
                    this.log.warn("Overriding type converter from: " + converter + " to: " + typeConverter);
                }
                this.typeMappings.put(key, typeConverter);
                this.misses.remove(key);
            }
        }
    }

    @Override
    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        this.log.trace("Adding fallback type converter: {} which can promote: {}", typeConverter, (Object)canPromote);
        this.fallbackConverters.add(0, new FallbackTypeConverter(typeConverter, canPromote));
        if (typeConverter instanceof TypeConverterAware) {
            TypeConverterAware typeConverterAware = (TypeConverterAware)((Object)typeConverter);
            typeConverterAware.setTypeConverter(this);
        }
    }

    public TypeConverter getTypeConverter(Class<?> toType, Class<?> fromType) {
        TypeMapping key = new TypeMapping(toType, fromType);
        return this.typeMappings.get(key);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> getFromClassMappings() {
        HashSet answer = new HashSet();
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            for (TypeMapping mapping : this.typeMappings.keySet()) {
                answer.add(mapping.getFromType());
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<?>, TypeConverter> getToClassMappings(Class<?> fromClass) {
        HashMap answer = new HashMap();
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            for (Map.Entry<TypeMapping, TypeConverter> entry : this.typeMappings.entrySet()) {
                TypeMapping mapping = entry.getKey();
                if (!mapping.isApplicable(fromClass)) continue;
                answer.put(mapping.getToType(), entry.getValue());
            }
        }
        return answer;
    }

    public Map<TypeMapping, TypeConverter> getTypeMappings() {
        return this.typeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> TypeConverter getOrFindTypeConverter(Class<?> toType, Object value) {
        TypeConverter converter;
        Class<?> fromType = null;
        if (value != null) {
            fromType = value.getClass();
        }
        TypeMapping key = new TypeMapping(toType, fromType);
        Map<TypeMapping, TypeConverter> map = this.typeMappings;
        synchronized (map) {
            converter = this.typeMappings.get(key);
            if (converter == null && (converter = this.lookup(toType, fromType)) != null) {
                this.typeMappings.put(key, converter);
            }
        }
        return converter;
    }

    @Override
    public TypeConverter lookup(Class<?> toType, Class<?> fromType) {
        return this.doLookup(toType, fromType, false);
    }

    protected TypeConverter doLookup(Class<?> toType, Class<?> fromType, boolean isSuper) {
        if (fromType != null) {
            TypeConverter converter = this.getTypeConverter(toType, fromType);
            if (converter != null) {
                return converter;
            }
            for (Class<?> type : fromType.getInterfaces()) {
                converter = this.getTypeConverter(toType, type);
                if (converter == null) continue;
                return converter;
            }
            Class<?> fromSuperClass = fromType.getSuperclass();
            if (fromSuperClass != null && !fromSuperClass.equals(Object.class) && (converter = this.doLookup(toType, fromSuperClass, true)) != null) {
                return converter;
            }
        }
        if (!isSuper && fromType != null && !fromType.equals(Object.class)) {
            Set<Map.Entry<TypeMapping, TypeConverter>> entries = this.typeMappings.entrySet();
            for (Map.Entry<TypeMapping, TypeConverter> entry : entries) {
                Class<?> aFromType;
                TypeMapping key = entry.getKey();
                Class<?> aToType = key.getToType();
                if (!toType.isAssignableFrom(aToType) || (aFromType = key.getFromType()).equals(Object.class) || !aFromType.isAssignableFrom(fromType)) continue;
                return entry.getValue();
            }
            TypeConverter converter = this.getTypeConverter(toType, Object.class);
            if (converter != null) {
                return converter;
            }
        }
        return null;
    }

    public void loadCoreTypeConverters() throws Exception {
        int before = this.typeMappings.size();
        CoreTypeConverterLoader core = new CoreTypeConverterLoader();
        core.load(this);
        int delta = this.typeMappings.size() - before;
        this.log.info("Loaded {} core type converters (total {} type converters)", delta, (Object)this.typeMappings.size());
    }

    protected void loadTypeConverters() throws Exception {
        StopWatch watch = new StopWatch();
        int before = this.typeMappings.size();
        this.log.debug("Loading additional type converters ...");
        for (TypeConverterLoader typeConverterLoader : this.getTypeConverterLoaders()) {
            typeConverterLoader.load(this);
        }
        try {
            this.loadFallbackTypeConverters();
        }
        catch (NoFactoryAvailableException e) {
            // empty catch block
        }
        this.log.debug("Loading additional type converters done");
        int delta = this.typeMappings.size() - before;
        if (this.log.isInfoEnabled()) {
            this.log.info("Loaded additional " + delta + " type converters (total " + this.typeMappings.size() + " type converters) in " + TimeUtils.printDuration(watch.stop()));
        }
    }

    protected void loadFallbackTypeConverters() throws IOException, ClassNotFoundException {
        List<TypeConverter> converters = this.factoryFinder.newInstances("FallbackTypeConverter", this.getInjector(), TypeConverter.class);
        for (TypeConverter converter : converters) {
            this.addFallbackTypeConverter(converter, false);
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.propertyEditorTypeConverter);
    }

    @Override
    protected void doStop() throws Exception {
        this.typeMappings.clear();
        this.misses.clear();
        ServiceHelper.stopService(this.propertyEditorTypeConverter);
    }

    protected static class FallbackTypeConverter {
        private boolean canPromote;
        private TypeConverter fallbackTypeConverter;

        FallbackTypeConverter(TypeConverter fallbackTypeConverter, boolean canPromote) {
            this.canPromote = canPromote;
            this.fallbackTypeConverter = fallbackTypeConverter;
        }

        public boolean isCanPromote() {
            return this.canPromote;
        }

        public TypeConverter getFallbackTypeConverter() {
            return this.fallbackTypeConverter;
        }
    }

    protected static class TypeMapping {
        Class<?> toType;
        Class<?> fromType;

        public TypeMapping(Class<?> toType, Class<?> fromType) {
            this.toType = toType;
            this.fromType = fromType;
        }

        public Class<?> getFromType() {
            return this.fromType;
        }

        public Class<?> getToType() {
            return this.toType;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMapping) {
                TypeMapping that = (TypeMapping)object;
                return ObjectHelper.equal(this.fromType, that.fromType) && ObjectHelper.equal(this.toType, that.toType);
            }
            return false;
        }

        public int hashCode() {
            int answer = this.toType.hashCode();
            if (this.fromType != null) {
                answer *= 37 + this.fromType.hashCode();
            }
            return answer;
        }

        public String toString() {
            return "[" + this.fromType + "=>" + this.toType + "]";
        }

        public boolean isApplicable(Class<?> fromClass) {
            return this.fromType.isAssignableFrom(fromClass);
        }
    }
}

