/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;

public abstract class ScheduledPollEndpoint
extends DefaultEndpoint {
    private Map<String, Object> consumerProperties;

    protected ScheduledPollEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    protected ScheduledPollEndpoint(String endpointUri, CamelContext context) {
        super(endpointUri, context);
    }

    protected ScheduledPollEndpoint(String endpointUri) {
        super(endpointUri);
    }

    protected ScheduledPollEndpoint() {
    }

    public Map<String, Object> getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Map<String, Object> consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    protected void configureConsumer(Consumer consumer) throws Exception {
        if (this.consumerProperties != null) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.consumerProperties);
            EndpointHelper.setReferenceProperties(this.getCamelContext(), consumer, copy);
            EndpointHelper.setProperties(this.getCamelContext(), consumer, copy);
            if (!this.isLenientProperties() && copy.size() > 0) {
                throw new ResolveEndpointFailedException(this.getEndpointUri(), "There are " + copy.size() + " parameters that couldn't be set on the endpoint consumer." + " Check the uri if the parameters are spelt correctly and that they are properties of the endpoint." + " Unknown consumer parameters=[" + copy + "]");
            }
        }
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        Map<String, Object> consumerProperties = IntrospectionSupport.extractProperties(options, "consumer.");
        if (consumerProperties != null) {
            this.setConsumerProperties(consumerProperties);
        }
        this.configureScheduledPollConsumerProperties(options, consumerProperties);
    }

    private void configureScheduledPollConsumerProperties(Map<String, Object> options, Map<String, Object> consumerProperties) {
        Object startScheduler = options.remove("startScheduler");
        Object initialDelay = options.remove("initialDelay");
        Object delay = options.remove("delay");
        Object timeUnit = options.remove("timeUnit");
        Object useFixedDelay = options.remove("useFixedDelay");
        Object pollStrategy = options.remove("pollStrategy");
        Object runLoggingLevel = options.remove("runLoggingLevel");
        if (initialDelay != null || delay != null || timeUnit != null || useFixedDelay != null || pollStrategy != null || runLoggingLevel != null || startScheduler != null) {
            if (consumerProperties == null) {
                consumerProperties = new HashMap<String, Object>();
            }
            if (initialDelay != null) {
                consumerProperties.put("initialDelay", initialDelay);
            }
            if (startScheduler != null) {
                consumerProperties.put("startScheduler", startScheduler);
            }
            if (delay != null) {
                consumerProperties.put("delay", delay);
            }
            if (timeUnit != null) {
                consumerProperties.put("timeUnit", timeUnit);
            }
            if (useFixedDelay != null) {
                consumerProperties.put("useFixedDelay", useFixedDelay);
            }
            if (pollStrategy != null) {
                consumerProperties.put("pollStrategy", pollStrategy);
            }
            if (runLoggingLevel != null) {
                consumerProperties.put("runLoggingLevel", runLoggingLevel);
            }
        }
    }
}

