/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUSoftCache;

public class EndpointRegistry
extends LRUSoftCache<EndpointKey, Endpoint> {
    private final CamelContext context;

    public EndpointRegistry(CamelContext context) {
        super(CamelContextHelper.getMaximumEndpointCacheSize(context));
        this.context = context;
    }

    public EndpointRegistry(CamelContext context, Map<EndpointKey, Endpoint> endpoints) {
        this(context);
        this.putAll(endpoints);
    }

    public void purge() {
        this.clear();
    }

    @Override
    public String toString() {
        return "EndpointRegistry for " + this.context.getName() + ", capacity: " + this.getMaxCacheSize();
    }
}

