/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.impl.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultProducer
extends ServiceSupport
implements Producer {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Endpoint endpoint;

    public DefaultProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "Producer[" + this.endpoint.getEndpointUri() + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Exchange createExchange() {
        return this.endpoint.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.endpoint.createExchange(pattern);
    }

    @Override
    public Exchange createExchange(Exchange exchange) {
        return this.endpoint.createExchange(exchange);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Starting producer: {}", this);
        } else {
            this.log.trace("Starting producer: {}", this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Stopping producer: {}", this);
        } else {
            this.log.trace("Stopping producer: {}", this);
        }
    }
}

