/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPollingConsumerPollStrategy
implements PollingConsumerPollStrategy {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean begin(Consumer consumer, Endpoint endpoint) {
        return true;
    }

    @Override
    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
    }

    @Override
    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
        boolean runAllowed = true;
        if (consumer instanceof ServiceSupport) {
            runAllowed = ((ServiceSupport)((Object)consumer)).isRunAllowed();
        }
        if (runAllowed) {
            this.log.warn("Consumer " + consumer + " could not poll endpoint: " + endpoint + " caused by: " + e.getMessage(), e);
        }
        return false;
    }
}

