/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.stream.StreamEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(StreamProducer.class);
    private static final String TYPES = "out,err,file,header,url";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{out,err,file,header,url}'";
    private static final List<String> TYPES_LIST = Arrays.asList("out,err,file,header,url".split(","));
    private StreamEndpoint endpoint;
    private String uri;

    public StreamProducer(StreamEndpoint endpoint, String uri) throws Exception {
        super(endpoint);
        this.endpoint = endpoint;
        this.validateUri(uri);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.delay(this.endpoint.getDelay());
        OutputStream outputStream = System.out;
        boolean isSystemStream = false;
        if ("out".equals(this.uri)) {
            isSystemStream = true;
            outputStream = System.out;
        } else if ("err".equals(this.uri)) {
            isSystemStream = true;
            outputStream = System.err;
        } else if ("file".equals(this.uri)) {
            outputStream = this.resolveStreamFromFile();
        } else if ("header".equals(this.uri)) {
            outputStream = this.resolveStreamFromHeader(exchange.getIn().getHeader("stream"), exchange);
        } else if ("url".equals(this.uri)) {
            outputStream = this.resolveStreamFromUrl();
        }
        this.writeToStream(outputStream, exchange);
        this.closeStream(outputStream, isSystemStream);
    }

    private OutputStream resolveStreamFromUrl() throws IOException {
        String u = this.endpoint.getUrl();
        ObjectHelper.notEmpty(u, "url");
        LOG.debug("About to write to url: {}", (Object)u);
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getOutputStream();
    }

    private OutputStream resolveStreamFromFile() throws IOException {
        String fileName = this.endpoint.getFileName();
        ObjectHelper.notEmpty(fileName, "fileName");
        LOG.debug("About to write to file: {}", (Object)fileName);
        File f = new File(fileName);
        f.createNewFile();
        return new FileOutputStream(f);
    }

    private OutputStream resolveStreamFromHeader(Object o, Exchange exchange) throws CamelExchangeException {
        return exchange.getContext().getTypeConverter().convertTo(OutputStream.class, o);
    }

    private void delay(long ms) throws InterruptedException {
        if (ms == 0L) {
            return;
        }
        LOG.trace("Delaying {} millis", ms);
        Thread.sleep(ms);
    }

    private void writeToStream(OutputStream outputStream, Exchange exchange) throws IOException, CamelExchangeException {
        byte[] bytes;
        Object body = exchange.getIn().getBody();
        if (!(body instanceof String) && (bytes = exchange.getIn().getBody(byte[].class)) != null) {
            LOG.debug("Writing as byte[]: {} to {}", bytes, (Object)outputStream);
            outputStream.write(bytes);
            return;
        }
        String s = exchange.getIn().getMandatoryBody(String.class);
        Charset charset = this.endpoint.getCharset();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        BufferedWriter bw = new BufferedWriter(writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing as text: {} to {} using encoding: {}", new Object[]{body, outputStream, charset});
        }
        bw.write(s);
        bw.write("\n");
        bw.flush();
    }

    private void closeStream(OutputStream outputStream, boolean isSystemStream) throws Exception {
        if (outputStream != null && !isSystemStream) {
            outputStream.close();
        }
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new IllegalArgumentException(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (this.uri.startsWith("//")) {
            this.uri = this.uri.substring(2);
        }
        if (!TYPES_LIST.contains(this.uri)) {
            throw new IllegalArgumentException(INVALID_URI);
        }
    }
}

