/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.component.file.GenericFileDefaultBinding;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFile<T> {
    private static final transient Logger LOG = LoggerFactory.getLogger(GenericFile.class);
    private String endpointPath;
    private String fileName;
    private String fileNameOnly;
    private String relativeFilePath;
    private String absoluteFilePath;
    private long fileLength;
    private long lastModified;
    private T file;
    private GenericFileBinding<T> binding;
    private boolean absolute;

    public char getFileSeparator() {
        return File.separatorChar;
    }

    public GenericFile<T> copyFrom(GenericFile<T> source) {
        GenericFile result;
        try {
            result = (GenericFile)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        result.setEndpointPath(source.getEndpointPath());
        result.setAbsolute(source.isAbsolute());
        result.setAbsoluteFilePath(source.getAbsoluteFilePath());
        result.setRelativeFilePath(source.getRelativeFilePath());
        result.setFileName(source.getFileName());
        result.setFileNameOnly(source.getFileNameOnly());
        result.setFileLength(source.getFileLength());
        result.setLastModified(source.getLastModified());
        result.setFile(source.getFile());
        result.setBody(source.getBody());
        result.setBinding(source.getBinding());
        this.copyFromPopulateAdditional(source, result);
        return result;
    }

    public void copyFromPopulateAdditional(GenericFile<T> source, GenericFile<T> result) {
    }

    public void bindToExchange(Exchange exchange) {
        Map<String, Object> headers;
        exchange.setProperty("CamelFileExchangeFile", this);
        GenericFileMessage msg = new GenericFileMessage(this);
        if (exchange.hasOut()) {
            headers = exchange.getOut().hasHeaders() ? exchange.getOut().getHeaders() : null;
            exchange.setOut(msg);
        } else {
            headers = exchange.getIn().hasHeaders() ? exchange.getIn().getHeaders() : null;
            exchange.setIn(msg);
        }
        if (headers != null) {
            msg.setHeaders(headers);
            msg.removeHeaders("CamelFile*");
        }
        this.populateHeaders(msg);
    }

    public void populateHeaders(GenericFileMessage<T> message) {
        if (message != null) {
            message.setHeader("CamelFileNameOnly", this.getFileNameOnly());
            message.setHeader("CamelFileName", this.getFileName());
            message.setHeader("CamelFileAbsolute", this.isAbsolute());
            message.setHeader("CamelFileAbsolutePath", this.getAbsoluteFilePath());
            if (this.isAbsolute()) {
                message.setHeader("CamelFilePath", this.getAbsoluteFilePath());
            } else {
                String path = this.normalizePathToProtocol(this.getEndpointPath() + File.separator + this.getRelativeFilePath());
                message.setHeader("CamelFilePath", path);
            }
            message.setHeader("CamelFileRelativePath", this.getRelativeFilePath());
            message.setHeader("CamelFileParent", this.getParent());
            if (this.getFileLength() >= 0L) {
                message.setHeader("CamelFileLength", this.getFileLength());
            }
            if (this.getLastModified() > 0L) {
                message.setHeader("CamelFileLastModified", new Date(this.getLastModified()));
            }
        }
    }

    protected boolean isAbsolute(String name) {
        return FileUtil.isAbsolute(new File(name));
    }

    protected String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    public void changeFileName(String newName) {
        LOG.trace("Changing name to: {}", (Object)newName);
        String newFileName = this.normalizePath(newName);
        LOG.trace("Normalized endpointPath: {}", (Object)this.endpointPath);
        LOG.trace("Normalized newFileName: ()", (Object)newFileName);
        File file = new File(newFileName);
        if (!this.absolute && ObjectHelper.isNotEmpty(this.endpointPath) && newFileName.startsWith(this.endpointPath)) {
            newFileName = this.endpointPath.endsWith("" + this.getFileSeparator()) ? ObjectHelper.after(newFileName, this.endpointPath) : ObjectHelper.after(newFileName, this.endpointPath + this.getFileSeparator());
            file = new File(newFileName);
        }
        this.setFileNameOnly(file.getName());
        this.setFileName(file.getName());
        if (file.getParent() != null) {
            this.setRelativeFilePath(file.getParent() + this.getFileSeparator() + file.getName());
        } else {
            this.setRelativeFilePath(file.getName());
        }
        if (this.isAbsolute(newFileName)) {
            this.setAbsolute(true);
            this.setAbsoluteFilePath(newFileName);
        } else {
            this.setAbsolute(false);
            String path = ObjectHelper.isEmpty(this.endpointPath) ? "" : this.endpointPath + this.getFileSeparator();
            this.setAbsoluteFilePath(path + this.getRelativeFilePath());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("FileNameOnly: {}", (Object)this.getFileNameOnly());
            LOG.trace("FileName: {}", (Object)this.getFileName());
            LOG.trace("Absolute: {}", this.isAbsolute());
            LOG.trace("Relative path: {}", (Object)this.getRelativeFilePath());
            LOG.trace("Absolute path: {}", (Object)this.getAbsoluteFilePath());
            LOG.trace("Name changed to: {}", this);
        }
    }

    public String getRelativeFilePath() {
        return this.relativeFilePath;
    }

    public void setRelativeFilePath(String relativeFilePath) {
        this.relativeFilePath = this.normalizePathToProtocol(relativeFilePath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = this.normalizePathToProtocol(fileName);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public T getFile() {
        return this.file;
    }

    public void setFile(T file) {
        this.file = file;
    }

    public Object getBody() {
        return this.getBinding().getBody(this);
    }

    public void setBody(Object os) {
        this.getBinding().setBody(this, os);
    }

    public String getParent() {
        String parent;
        if (this.isAbsolute()) {
            String name = this.getAbsoluteFilePath();
            File path = new File(name);
            parent = path.getParent();
        } else {
            String name = this.getRelativeFilePath();
            File path = name != null ? new File(this.endpointPath, name) : new File(this.endpointPath);
            parent = path.getParent();
        }
        return this.normalizePathToProtocol(parent);
    }

    public GenericFileBinding<T> getBinding() {
        if (this.binding == null) {
            this.binding = new GenericFileDefaultBinding();
        }
        return this.binding;
    }

    public void setBinding(GenericFileBinding<T> binding) {
        this.binding = binding;
    }

    public void setAbsoluteFilePath(String absoluteFilePath) {
        this.absoluteFilePath = this.normalizePathToProtocol(absoluteFilePath);
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public void setEndpointPath(String endpointPath) {
        this.endpointPath = this.normalizePathToProtocol(endpointPath);
    }

    public String getFileNameOnly() {
        return this.fileNameOnly;
    }

    public void setFileNameOnly(String fileNameOnly) {
        this.fileNameOnly = fileNameOnly;
    }

    protected String normalizePathToProtocol(String path) {
        if (ObjectHelper.isEmpty(path)) {
            return path;
        }
        path = path.replace('/', this.getFileSeparator());
        path = path.replace('\\', this.getFileSeparator());
        return path;
    }

    public String toString() {
        return "GenericFile[" + (this.absolute ? this.absoluteFilePath : this.relativeFilePath) + "]";
    }
}

