/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.component.CamelResourceLoader;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class ResourceBasedEndpoint
extends ProcessorEndpoint {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String resourceUri;
    private ResourceLoader resourceLoader;
    private Resource resource;
    private boolean contentCache;
    private byte[] buffer;

    protected ResourceBasedEndpoint() {
    }

    public ResourceBasedEndpoint(String endpointUri, Component component, String resourceUri, Processor processor) {
        super(endpointUri, component, processor);
        this.resourceUri = resourceUri;
        if (component instanceof ResourceBasedComponent) {
            this.resourceLoader = ((ResourceBasedComponent)component).getResourceLoader();
        }
    }

    protected ResourceBasedEndpoint(String endpointUri, Processor processor, String resourceUri) {
        super(endpointUri, processor);
        this.resourceUri = resourceUri;
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.log.debug("Loading resource: {} using: {}", (Object)this.resourceUri, (Object)this.getResourceLoader());
            this.resource = this.getResourceLoader().getResource(this.resourceUri);
            if (this.resource == null) {
                throw new IllegalArgumentException("Could not find resource for URI: " + this.resourceUri + " using: " + this.getResourceLoader());
            }
        }
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsInputStream() throws IOException {
        if (this.resource == null) {
            this.resource = this.getResource();
        }
        InputStream is = null;
        if (this.contentCache) {
            Resource resource = this.resource;
            synchronized (resource) {
                if (this.buffer == null) {
                    this.log.debug("Reading resource: {} into the content cache", (Object)this.resourceUri);
                    is = this.getResourceAsInputStreamWithoutCache();
                    this.buffer = IOConverter.toBytes(is);
                }
            }
            this.log.debug("Using resource: {} from the content cache", (Object)this.resourceUri);
            return new ByteArrayInputStream(this.buffer);
        }
        return this.getResourceAsInputStreamWithoutCache();
    }

    protected InputStream getResourceAsInputStreamWithoutCache() throws IOException {
        InputStream result;
        block2: {
            try {
                result = this.resource.getInputStream();
            }
            catch (IOException exception) {
                result = this.getCamelContext().getClassResolver().loadResourceAsStream(this.resourceUri);
                if (result != null) break block2;
                this.log.warn("Cannot get the resource: " + this.resourceUri + "from the camelContext ClassResolver");
                throw exception;
            }
        }
        return result;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = new CamelResourceLoader(this.getCamelContext());
        }
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

