/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import org.apache.camel.component.CamelResourceLoader;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class ResourceBasedComponent
extends DefaultComponent {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceLoader resourceLoader;

    public ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = new CamelResourceLoader(this.getCamelContext());
        }
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Resource resolveMandatoryResource(String uri) {
        Resource resource = this.getResourceLoader().getResource(uri);
        if (resource == null) {
            throw new IllegalArgumentException("Could not find resource for URI: " + uri + " using: " + this.getResourceLoader());
        }
        return resource;
    }
}

