/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceLogger
implements ServerService {
    private final Log log;
    private final ServerService next;
    private final String[] logOnSuccess;
    private final String[] logOnFailure;
    private final String name;

    public ServiceLogger(String name, ServerService next, String[] logOnSuccess, String[] logOnFailure) {
        this.log = LogFactory.getLog("OpenEJB.server.service." + name);
        this.next = next;
        this.logOnSuccess = logOnSuccess;
        this.logOnFailure = logOnFailure;
        this.name = name;
    }

    public void service(Socket socket) throws ServiceException, IOException {
        InetAddress client = socket.getInetAddress();
        try {
            this.logIncoming();
            this.next.service(socket);
            this.logSuccess();
        }
        catch (Exception e) {
            this.logFailure(e);
            e.printStackTrace();
        }
    }

    public String[] getLogOnSuccess() {
        return this.logOnSuccess;
    }

    public String[] getLogOnFailure() {
        return this.logOnFailure;
    }

    private void logIncoming() {
        this.log.trace("incomming request");
    }

    private void logSuccess() {
        this.log.trace("successful request");
    }

    private void logFailure(Exception e) {
        this.log.error(e.getMessage());
    }

    public void init(Properties props) throws Exception {
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }
}

