/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.examples.cxf.jaxrs.security.client;

import java.io.File;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public final class Client {
    private Client() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        BasicScheme scheme = new BasicScheme();
        System.out.println("Sent HTTP GET request to query customer info with basic authentication info.");
        GetMethod get = new GetMethod("http://localhost:8181/cxf/securecrm/customerservice/customers/123");
        get.getHostAuthState().setAuthScheme((AuthScheme)scheme);
        try {
            httpClient.executeMethod((HttpMethod)get);
            System.out.println(get.getResponseBodyAsString());
        }
        finally {
            get.releaseConnection();
        }
        System.out.println("\n");
        System.out.println("Sent HTTP GET request to query customer info without basic authentication info.");
        get = new GetMethod("http://localhost:8181/cxf/securecrm/customerservice/customers/123");
        try {
            httpClient.executeMethod((HttpMethod)get);
            System.out.println(get.getResponseBodyAsString());
        }
        finally {
            get.releaseConnection();
        }
        System.out.println("\n");
        System.out.println("Sent HTTP GET request to query sub resource product info");
        get = new GetMethod("http://localhost:8181/cxf/securecrm/customerservice/orders/223/products/323");
        get.getHostAuthState().setAuthScheme((AuthScheme)scheme);
        try {
            httpClient.executeMethod((HttpMethod)get);
            System.out.println(get.getResponseBodyAsString());
        }
        finally {
            get.releaseConnection();
        }
        System.out.println("\n");
        System.out.println("Sent HTTP PUT request to update customer info");
        String inputFile = Client.class.getResource("update_customer.xml").getFile();
        File input = new File(inputFile);
        PutMethod put = new PutMethod("http://localhost:8181/cxf/securecrm/customerservice/customers");
        put.getHostAuthState().setAuthScheme((AuthScheme)scheme);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        try {
            int result = httpClient.executeMethod((HttpMethod)put);
            System.out.println("Response status code: " + result);
            System.out.println("Response body: ");
            System.out.println(put.getResponseBodyAsString());
        }
        finally {
            put.releaseConnection();
        }
        System.out.println("\n");
        System.out.println("Sent HTTP POST request to add customer");
        inputFile = Client.class.getResource("add_customer.xml").getFile();
        input = new File(inputFile);
        PostMethod post = new PostMethod("http://localhost:8181/cxf/securecrm/customerservice/customers");
        post.getHostAuthState().setAuthScheme((AuthScheme)scheme);
        post.addRequestHeader("Accept", "text/xml");
        entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        try {
            int result = httpClient.executeMethod((HttpMethod)post);
            System.out.println("Response status code: " + result);
            System.out.println("Response body: ");
            System.out.println(post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
        System.out.println("\n");
        System.exit(0);
    }
}

