/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.demo.activemq;

import java.util.Dictionary;
import javax.jms.JMSException;
import org.fusesource.mq.ActiveMQService;
import org.fusesource.mq.JMSService;
import org.fusesource.mq.ProducerThread;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQProducerFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQProducerFactory.class);
    ProducerThread producer;
    ActiveMQService producerService;

    public String getName() {
        return "ActiveMQ Producer Factory";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            String brokerUrl = (String)properties.get("brokerUrl");
            if (brokerUrl == null) {
                brokerUrl = "discover:(fabric:default)";
            }
            this.producerService = new ActiveMQService((String)properties.get("username"), (String)properties.get("password"), brokerUrl);
            this.producerService.setMaxAttempts(10);
            this.producerService.start();
            String destination = (String)properties.get("destination");
            this.producer = new ProducerThread((JMSService)this.producerService, destination);
            this.producer.setSleep(500);
            this.producer.start();
            LOG.info("Producer started " + pid + " started");
        }
        catch (JMSException e) {
            throw new ConfigurationException(null, "Cannot start producer", (Throwable)e);
        }
    }

    public void deleted(String pid) {
        this.destroy();
    }

    public void destroy() {
        if (this.producer != null) {
            this.producer.setRunning(false);
            this.producerService.stop();
        }
    }
}

