/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.examples.errors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import org.apache.camel.Header;
import org.apache.camel.language.NamespacePrefix;
import org.apache.camel.language.XPath;
import org.fusesource.examples.errors.OrderValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderService {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderService.class);
    private static final Random RANDOM = new Random();

    public void validateOrderDate(@XPath(value="/order:order/order:date", namespaces={@NamespacePrefix(prefix="order", uri="http://fusesource.com/examples/order/v7")}) String date) throws OrderValidationException {
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(DATE_FORMAT.parse(date));
            if (calendar.get(7) == 1) {
                LOGGER.warn("Order validation failure: order date " + date + " should not be a Sunday");
                throw new OrderValidationException("Order date should not be a Sunday: " + date);
            }
        }
        catch (ParseException e) {
            throw new OrderValidationException("Invalid order date: " + date);
        }
    }

    public void randomlyThrowRuntimeException(@Header(value="CamelFileName") String name) {
        if (RANDOM.nextInt(3) > 0) {
            LOGGER.warn("An unexcepted runtime exception occurred while processing " + name);
            throw new RuntimeException("Something else went wrong while handling this message");
        }
    }
}

