/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F0;
import fj.F1Functions;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.DList;
import fj.data.IO;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Semigroup<A> {
    private final Definition<A> def;
    public static final Semigroup<Integer> intAdditionSemigroup = Monoid.intAdditionMonoid.semigroup();
    @Deprecated
    public static final Semigroup<Double> doubleAdditionSemigroup = Semigroup.semigroupDef((A d1, A d2) -> d1 + d2);
    public static final Semigroup<Integer> intMultiplicationSemigroup = Monoid.intMultiplicationMonoid.semigroup();
    @Deprecated
    public static final Semigroup<Double> doubleMultiplicationSemigroup = Semigroup.semigroupDef((A d1, A d2) -> d1 * d2);
    public static final Semigroup<Integer> intMaximumSemigroup = Monoid.intMaxMonoid.semigroup();
    public static final Semigroup<Integer> intMinimumSemigroup = Monoid.intMinMonoid.semigroup();
    public static final Semigroup<BigInteger> bigintAdditionSemigroup = Monoid.bigintAdditionMonoid.semigroup();
    public static final Semigroup<BigInteger> bigintMultiplicationSemigroup = Semigroup.semigroup(BigInteger::multiply);
    public static final Semigroup<BigInteger> bigintMaximumSemigroup = Ord.bigintOrd.maxSemigroup();
    public static final Semigroup<BigInteger> bigintMinimumSemigroup = Ord.bigintOrd.minSemigroup();
    public static final Semigroup<BigDecimal> bigdecimalAdditionSemigroup = Monoid.bigdecimalAdditionMonoid.semigroup();
    public static final Semigroup<BigDecimal> bigdecimalMultiplicationSemigroup = Monoid.bigdecimalMultiplicationMonoid.semigroup();
    public static final Semigroup<BigDecimal> bigDecimalMaximumSemigroup = Ord.bigdecimalOrd.maxSemigroup();
    public static final Semigroup<BigDecimal> bigDecimalMinimumSemigroup = Ord.bigdecimalOrd.minSemigroup();
    public static final Semigroup<Natural> naturalMultiplicationSemigroup = Monoid.naturalMultiplicationMonoid.semigroup();
    public static final Semigroup<Natural> naturalAdditionSemigroup = Monoid.naturalAdditionMonoid.semigroup();
    public static final Semigroup<Natural> naturalMaximumSemigroup = Ord.naturalOrd.maxSemigroup();
    public static final Semigroup<Natural> naturalMinimumSemigroup = Ord.naturalOrd.minSemigroup();
    public static final Semigroup<Long> longAdditionSemigroup = Monoid.longAdditionMonoid.semigroup();
    public static final Semigroup<Long> longMultiplicationSemigroup = Monoid.longMultiplicationMonoid.semigroup();
    public static final Semigroup<Long> longMaximumSemigroup = Ord.longOrd.maxSemigroup();
    public static final Semigroup<Long> longMinimumSemigroup = Ord.longOrd.minSemigroup();
    public static final Semigroup<Boolean> disjunctionSemigroup = Monoid.disjunctionMonoid.semigroup();
    public static final Semigroup<Boolean> exclusiveDisjunctionSemiGroup = Monoid.exclusiveDisjunctionMonoid.semigroup();
    public static final Semigroup<Boolean> conjunctionSemigroup = Monoid.conjunctionMonoid.semigroup();
    public static final Semigroup<String> stringSemigroup = Monoid.stringMonoid.semigroup();
    public static final Semigroup<StringBuffer> stringBufferSemigroup = Monoid.stringBufferMonoid.semigroup();
    public static final Semigroup<StringBuilder> stringBuilderSemigroup = Monoid.stringBuilderMonoid.semigroup();
    public static final Semigroup<Unit> unitSemigroup = Monoid.unitMonoid.semigroup();

    private Semigroup(Definition<A> def) {
        this.def = def;
    }

    public A sum(A a1, A a2) {
        return this.def.append(a1, a2);
    }

    public F<A, A> sum(A a1) {
        return this.def.prepend(a1);
    }

    public F<A, F<A, A>> sum() {
        return this.def::prepend;
    }

    public A multiply1p(int n, A a) {
        return this.def.multiply1p(n, a);
    }

    public A sumNel(NonEmptyList<A> as) {
        return (A)as.foldLeft1(this.def::append);
    }

    public A sumStream(A a, F0<Stream<A>> as) {
        return this.def.sum(a, as);
    }

    public Semigroup<A> dual() {
        return Semigroup.semigroupDef(this.def.dual());
    }

    public Monoid<Option<A>> lift() {
        final Definition<A> def = this.def;
        return Monoid.monoidDef(new Monoid.Definition<Option<A>>(){

            @Override
            public Option<A> empty() {
                return Option.none();
            }

            @Override
            public Option<A> append(Option<A> a1, Option<A> a2) {
                return a1.liftM2(a1, def::append).orElse(a1).orElse(a2);
            }

            @Override
            public Option<A> multiply(int n, Option<A> oa) {
                return n > 0 ? oa.map(a -> def.multiply1p(n - 1, a)) : Option.none();
            }

            @Override
            public Option<A> sum(F0<Stream<Option<A>>> oas) {
                Stream as = oas.f().bind(Option::toStream);
                return as.uncons(Option.none(), h -> tail -> Option.some(def.sum(h, tail::_1)));
            }
        });
    }

    public <B> Semigroup<B> xmap(final F<A, B> f, final F<B, A> g) {
        final Definition<A> def = this.def;
        return Semigroup.semigroupDef(new Definition<B>(){

            @Override
            public B append(B a1, B a2) {
                return f.f(def.append(g.f(a1), g.f(a2)));
            }

            @Override
            public F<B, B> prepend(B b) {
                return F1Functions.dimap(def.prepend(g.f(b)), g, f);
            }

            @Override
            public B multiply1p(int n, B b) {
                return f.f(def.multiply1p(n, g.f(b)));
            }

            @Override
            public B sum(B b, F0<Stream<B>> bs) {
                return f.f(def.sum(g.f(b), () -> ((Stream)bs.f()).map(g)));
            }
        });
    }

    public <B, C> Semigroup<C> compose(Semigroup<B> sb, final F<C, B> b, final F<C, A> a, final F2<A, B, C> c) {
        final Definition<A> saDef = this.def;
        final Definition<A> sbDef = sb.def;
        return Semigroup.semigroupDef(new Definition<C>(){

            @Override
            public C append(C c1, C c2) {
                return c.f(saDef.append(a.f(c1), a.f(c2)), sbDef.append(b.f(c1), b.f(c2)));
            }

            @Override
            public F<C, C> prepend(C c1) {
                F prependA = saDef.prepend(a.f(c1));
                F prependB = sbDef.prepend(b.f(c1));
                return c2 -> c.f(prependA.f(a.f(c2)), prependB.f(b.f(c2)));
            }

            @Override
            public C multiply1p(int n, C c1) {
                return c.f(saDef.multiply1p(n, a.f(c1)), sbDef.multiply1p(n, b.f(c1)));
            }

            @Override
            public C sum(C c1, F0<Stream<C>> cs) {
                return c.f(saDef.sum(a.f(c1), () -> ((Stream)cs.f()).map(a)), sbDef.sum(b.f(c1), () -> ((Stream)cs.f()).map(b)));
            }
        });
    }

    public Monoid<A> monoid(A zero) {
        return Monoid.monoidDef(this.def, zero);
    }

    public static <A> Semigroup<A> semigroupDef(Definition<A> def) {
        return new Semigroup<A>(def);
    }

    public static <A> Semigroup<A> semigroupDef(AltDefinition<A> def) {
        return new Semigroup<A>(def);
    }

    public static <A> Semigroup<A> semigroup(F<A, F<A, A>> sum) {
        return Semigroup.semigroupDef(sum::f);
    }

    public static <A> Semigroup<A> semigroup(F2<A, A, A> sum) {
        return new Semigroup<Object>(sum::f);
    }

    public static <A> Semigroup<A> firstSemigroup() {
        return Semigroup.semigroupDef(new Definition<A>(){

            @Override
            public A append(A a1, A a2) {
                return a1;
            }

            @Override
            public F<A, A> prepend(A a) {
                return Function.constant(a);
            }

            @Override
            public A multiply1p(int n, A a) {
                return a;
            }

            @Override
            public A sum(A a, F0<Stream<A>> as) {
                return a;
            }
        });
    }

    public static <A> Semigroup<A> lastSemigroup() {
        return Semigroup.semigroupDef(new Definition<A>(){

            @Override
            public A append(A a1, A a2) {
                return a2;
            }

            @Override
            public F<A, A> prepend(A a) {
                return Function.identity();
            }

            @Override
            public A multiply1p(int n, A a) {
                return a;
            }
        });
    }

    public static <A, B> Semigroup<F<A, B>> functionSemigroup(Semigroup<B> sb) {
        Definition sbDef = sb.def;
        return Semigroup.semigroupDef((A a1, A a2) -> a -> sbDef.append(a1.f(a), a2.f(a)));
    }

    public static <A> Semigroup<List<A>> listSemigroup() {
        return Monoid.listMonoid().semigroup();
    }

    public static <A> Semigroup<NonEmptyList<A>> nonEmptyListSemigroup() {
        return Semigroup.semigroupDef(new Definition<NonEmptyList<A>>(){

            @Override
            public NonEmptyList<A> append(NonEmptyList<A> a1, NonEmptyList<A> a2) {
                return a1.append(a2);
            }

            @Override
            public NonEmptyList<A> sum(NonEmptyList<A> nea, F0<Stream<NonEmptyList<A>>> neas) {
                List tail = neas.f().map(nel -> DList.listDList(nel.toList())).foldLeft(DList::append, DList.nil()).run();
                return nea.append(tail);
            }
        });
    }

    public static <A> Semigroup<Option<A>> optionSemigroup() {
        return Semigroup.firstOptionSemigroup();
    }

    public static <A> Semigroup<Option<A>> firstOptionSemigroup() {
        return Monoid.firstOptionMonoid().semigroup();
    }

    public static <A> Semigroup<Option<A>> lastOptionSemigroup() {
        return Monoid.lastOptionMonoid().semigroup();
    }

    public static <A> Semigroup<Stream<A>> streamSemigroup() {
        return Monoid.streamMonoid().semigroup();
    }

    public static <A> Semigroup<Array<A>> arraySemigroup() {
        return Monoid.arrayMonoid().semigroup();
    }

    public static <A> Semigroup<P1<A>> p1Semigroup(Semigroup<A> sa) {
        final Definition<A> def = sa.def;
        return Semigroup.semigroupDef(new Definition<P1<A>>(){

            @Override
            public P1<A> append(P1<A> a1, P1<A> a2) {
                return P.lazy(() -> def.append(a1._1(), a2._1()));
            }

            @Override
            public P1<A> multiply1p(int n, P1<A> ap1) {
                return P.lazy(() -> def.multiply1p(n, ap1._1()));
            }

            @Override
            public P1<A> sum(P1<A> ap1, F0<Stream<P1<A>>> as) {
                return P.lazy(() -> def.sum(ap1._1(), () -> ((Stream)as.f()).map(P1.__1())));
            }
        });
    }

    public static <A, B> Semigroup<P2<A, B>> p2Semigroup(Semigroup<A> sa, Semigroup<B> sb) {
        return Semigroup.semigroupDef((A a1, A a2) -> P.lazy(() -> sa.sum(a1._1(), a2._1()), () -> sb.sum(a1._2(), a2._2())));
    }

    public static <A> Semigroup<IO<A>> ioSemigroup(Semigroup<A> sa) {
        Definition def = sa.def;
        return Semigroup.semigroupDef((A a1, A a2) -> () -> def.append(a1.run(), a2.run()));
    }

    public static <A> Semigroup<Set<A>> setSemigroup() {
        return Semigroup.semigroupDef(Set::union);
    }

    public static interface AltDefinition<A>
    extends Definition<A> {
        @Override
        public F<A, A> prepend(A var1);

        @Override
        default public A append(A a1, A a2) {
            return this.prepend(a1).f(a2);
        }
    }

    public static interface Definition<A> {
        public A append(A var1, A var2);

        default public F<A, A> prepend(A a) {
            return a2 -> this.append(a, a2);
        }

        default public A sum(A a, F0<Stream<A>> as) {
            return (A)as.f().foldLeft(this::append, a);
        }

        default public A multiply1p(int n, A a) {
            if (n <= 0) {
                return a;
            }
            A xTmp = a;
            int yTmp = n;
            A zTmp = a;
            while (true) {
                if ((yTmp & 1) == 1) {
                    zTmp = this.append(xTmp, zTmp);
                    if (yTmp == 1) {
                        return zTmp;
                    }
                }
                xTmp = this.append(xTmp, xTmp);
                yTmp >>>= 1;
            }
        }

        default public Definition<A> dual() {
            return new Definition<A>(){

                @Override
                public A append(A a1, A a2) {
                    return this.append(a2, a1);
                }

                @Override
                public A multiply1p(int n, A a) {
                    return this.multiply1p(n, a);
                }
            };
        }
    }
}

