/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Stream;

public final class Booleans {
    public static final F<Boolean, F<Boolean, Boolean>> or = Semigroup.disjunctionSemigroup.sum();
    public static final F<Boolean, F<Boolean, Boolean>> and = Semigroup.conjunctionSemigroup.sum();
    public static final F<Boolean, F<Boolean, Boolean>> xor = Semigroup.exclusiveDisjunctionSemiGroup.sum();
    public static final F<Boolean, Boolean> not = p -> p == false;
    public static final F<Boolean, F<Boolean, Boolean>> implies = Function.curry((p, q) -> p == false || q != false);
    public static final F<Boolean, F<Boolean, Boolean>> if_ = Function.flip(implies);
    public static final F<Boolean, F<Boolean, Boolean>> iff = Function.compose2(not, xor);
    public static final F<Boolean, F<Boolean, Boolean>> nimp = Function.compose2(not, implies);
    public static final F<Boolean, F<Boolean, Boolean>> nif = Function.compose2(not, if_);
    public static final F<Boolean, F<Boolean, Boolean>> nor = Function.compose2(not, or);

    private Booleans() {
        throw new UnsupportedOperationException();
    }

    public static boolean and(List<Boolean> l) {
        return Monoid.conjunctionMonoid.sumLeft(l);
    }

    public static <A, B> F<B, Boolean> contramap(F<B, A> f, F<A, Boolean> p) {
        return Function.compose(p, f);
    }

    public static <A, B> F<B, Boolean> is(F<B, A> f, F<A, Boolean> p) {
        return Booleans.contramap(f, p);
    }

    public static <A, B> F<B, Boolean> isnot(F<B, A> f, F<A, Boolean> p) {
        return Function.compose(not, Booleans.contramap(f, p));
    }

    public static <A> F<A, Boolean> and(F<A, Boolean> p1, F<A, Boolean> p2) {
        return Semigroup.functionSemigroup(Semigroup.conjunctionSemigroup).sum(p1, p2);
    }

    public static <A> F<A, Boolean> xor(F<A, Boolean> p1, F<A, Boolean> p2) {
        return Semigroup.functionSemigroup(Semigroup.exclusiveDisjunctionSemiGroup).sum(p1, p2);
    }

    public static <A> F<A, Boolean> or(F<A, Boolean> p1, F<A, Boolean> p2) {
        return Semigroup.functionSemigroup(Semigroup.disjunctionSemigroup).sum(p1, p2);
    }

    public static boolean and(Stream<Boolean> l) {
        return Monoid.conjunctionMonoid.sumLeft(l);
    }

    public static <A> F<A, Boolean> andAll(Stream<F<A, Boolean>> l) {
        return Monoid.functionMonoid(Monoid.conjunctionMonoid).sumLeft(l);
    }

    public static <A> F<A, Boolean> andAll(List<F<A, Boolean>> l) {
        return Monoid.functionMonoid(Monoid.conjunctionMonoid).sumLeft(l);
    }

    public static <A> F<A, Boolean> orAll(List<F<A, Boolean>> l) {
        return Monoid.functionMonoid(Monoid.disjunctionMonoid).sumLeft(l);
    }

    public static <A> F<A, Boolean> orAll(Stream<F<A, Boolean>> l) {
        return Monoid.functionMonoid(Monoid.disjunctionMonoid).sumLeft(l);
    }

    public static boolean or(List<Boolean> l) {
        return Monoid.disjunctionMonoid.sumLeft(l);
    }

    public static boolean or(Stream<Boolean> l) {
        return Monoid.disjunctionMonoid.sumLeft(l);
    }

    public static <A> F<A, Boolean> not(F<A, Boolean> p) {
        return Function.compose(not, p);
    }

    public static <A> F<Boolean, F<A, F<A, A>>> cond() {
        return Function.curry((p, a1, a2) -> p != false ? a1 : a2);
    }
}

