/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.Function;
import fj.P;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.data.fingertrees.Digit;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Node;
import fj.data.fingertrees.One;
import fj.data.fingertrees.Single;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;

public final class Deep<V, A>
extends FingerTree<V, A> {
    private final V v;
    private final Digit<V, A> prefix;
    private final FingerTree<V, Node<V, A>> middle;
    private final Digit<V, A> suffix;

    Deep(Measured<V, A> m, V v, Digit<V, A> prefix, FingerTree<V, Node<V, A>> middle, Digit<V, A> suffix) {
        super(m);
        this.v = v;
        this.prefix = prefix;
        this.middle = middle;
        this.suffix = suffix;
    }

    public Digit<V, A> prefix() {
        return this.prefix;
    }

    public FingerTree<V, Node<V, A>> middle() {
        return this.middle;
    }

    public Digit<V, A> suffix() {
        return this.suffix;
    }

    @Override
    public <B> B foldRight(F<A, F<B, B>> aff, B z) {
        return this.prefix.foldRight(aff, this.middle.foldRight(Function.flip(Node.foldRight_(aff)), this.suffix.foldRight(aff, z)));
    }

    @Override
    public A reduceRight(F<A, F<A, A>> aff) {
        return this.prefix.foldRight(aff, this.middle.foldRight(Function.flip(Node.foldRight_(aff)), this.suffix.reduceRight(aff)));
    }

    @Override
    public <B> B foldLeft(F<B, F<A, B>> bff, B z) {
        return this.suffix.foldLeft(bff, this.middle.foldLeft(Node.foldLeft_(bff), this.prefix.foldLeft(bff, z)));
    }

    @Override
    public A reduceLeft(F<A, F<A, A>> aff) {
        return this.suffix.foldLeft(aff, this.middle.foldLeft(Node.foldLeft_(aff), this.prefix.reduceLeft(aff)));
    }

    @Override
    public <B> FingerTree<V, B> map(F<A, B> abf, Measured<V, B> m) {
        return new Deep<V, B>(m, this.v, this.prefix.map(abf, m), this.middle.map(Node.liftM(abf, m), m.nodeMeasured()), this.suffix.map(abf, m));
    }

    @Override
    public V measure() {
        return this.v;
    }

    @Override
    public <B> B match(F<Empty<V, A>, B> empty, F<Single<V, A>, B> single, F<Deep<V, A>, B> deep) {
        return deep.f(this);
    }

    @Override
    public FingerTree<V, A> cons(A a) {
        Measured m = this.measured();
        Object measure = m.sum(m.measure(a), this.v);
        MakeTree mk = Deep.mkTree(m);
        return this.prefix.match(one -> new Deep<Object, Object>(m, measure, mk.two(a, one.value()), this.middle, this.suffix), two -> new Deep<Object, Object>(m, measure, mk.three(a, two.values()._1(), two.values()._2()), this.middle, this.suffix), three -> new Deep<Object, Object>(m, measure, mk.four(a, three.values()._1(), three.values()._2(), three.values()._3()), this.middle, this.suffix), four -> new Deep<Object, Object>(m, measure, mk.two(a, four.values()._1()), this.middle.cons(mk.node3(four.values()._2(), four.values()._3(), four.values()._4())), this.suffix));
    }

    @Override
    public FingerTree<V, A> snoc(A a) {
        Measured m = this.measured();
        Object measure = m.sum(m.measure(a), this.v);
        MakeTree mk = Deep.mkTree(m);
        return this.suffix.match(one -> new Deep<Object, Object>(m, measure, this.prefix, this.middle, mk.two(one.value(), a)), two -> new Deep<Object, Object>(m, measure, this.prefix, this.middle, mk.three(two.values()._1(), two.values()._2(), a)), three -> new Deep<Object, Object>(m, measure, this.prefix, this.middle, mk.four(three.values()._1(), three.values()._2(), three.values()._3(), a)), four -> new Deep<Object, Object>(m, measure, this.prefix, this.middle.snoc(mk.node3(four.values()._1(), four.values()._2(), four.values()._3())), mk.two(four.values()._4(), a)));
    }

    @Override
    public A head() {
        return (A)this.prefix.match(One::value, two -> two.values()._1(), three -> three.values()._1(), four -> four.values()._1());
    }

    @Override
    public A last() {
        return (A)this.suffix.match(One::value, two -> two.values()._2(), three -> three.values()._3(), four -> four.values()._4());
    }

    private static <V, A> FingerTree<V, A> deepL(Measured<V, A> measured, Option<Digit<V, A>> lOpt, FingerTree<V, Node<V, A>> m, Digit<V, A> r) {
        return lOpt.option(P.lazy(() -> m.isEmpty() ? r.toTree() : Deep.mkTree(measured).deep(((Node)m.head()).toDigit(), m.tail(), r)), l -> Deep.mkTree(measured).deep(l, m, r));
    }

    private static <V, A> FingerTree<V, A> deepR(Measured<V, A> measured, Option<Digit<V, A>> rOpt, FingerTree<V, Node<V, A>> m, Digit<V, A> l) {
        return rOpt.option(P.lazy(() -> m.isEmpty() ? l.toTree() : Deep.mkTree(measured).deep(l, m.init(), ((Node)m.last()).toDigit())), r -> Deep.mkTree(measured).deep(l, m, r));
    }

    @Override
    public FingerTree<V, A> tail() {
        return Deep.deepL(this.measured(), this.prefix.tail(), this.middle, this.suffix);
    }

    @Override
    public FingerTree<V, A> init() {
        return Deep.deepR(this.measured(), this.suffix.init(), this.middle, this.prefix);
    }

    @Override
    public FingerTree<V, A> append(FingerTree<V, A> t) {
        Measured m = this.measured();
        return t.match(Function.constant(this), single -> this.snoc(single.value()), deep -> new Deep<V, A>(m, m.sum(this.measure(), deep.measure()), this.prefix, Deep.addDigits0(m, this.middle, this.suffix, deep.prefix, deep.middle), deep.suffix));
    }

    @Override
    P3<FingerTree<V, A>, A, FingerTree<V, A>> split1(F<V, Boolean> predicate, V acc) {
        Measured m = this.measured();
        Object accL = m.sum(acc, this.prefix.measure());
        if (predicate.f(accL).booleanValue()) {
            P3<Option<Digit<V, A>>, A, Option<Digit<V, A>>> lxr = this.prefix.split1(predicate, acc);
            return P.p(lxr._1().option(new Empty(m), Digit::toTree), lxr._2(), Deep.deepL(m, lxr._3(), this.middle, this.suffix));
        }
        Object accM = m.sum(accL, this.middle.measure());
        if (predicate.f(accM).booleanValue()) {
            P3<FingerTree<V, Node<V, A>>, Node<V, A>, FingerTree<V, Node<V, A>>> mlXsMr = this.middle.split1(predicate, accL);
            P3<Option<Digit<V, A>>, A, Option<Digit<V, A>>> lxr = mlXsMr._2().split1(predicate, m.sum(accL, mlXsMr._1().measure()));
            return P.p(Deep.deepR(m, lxr._1(), mlXsMr._1(), this.prefix), lxr._2(), Deep.deepL(m, lxr._3(), mlXsMr._3(), this.suffix));
        }
        P3<Option<Digit<V, A>>, A, Option<Digit<V, A>>> lxr = this.suffix.split1(predicate, accM);
        return P.p(Deep.deepR(m, lxr._1(), this.middle, this.prefix), lxr._2(), lxr._3().option(new Empty(m), Digit::toTree));
    }

    @Override
    public P2<Integer, A> lookup(F<V, Integer> o, int i) {
        int spr = o.f(this.prefix.measure());
        if (i < spr) {
            return this.prefix.lookup(o, i);
        }
        int spm = spr + o.f(this.middle.measure());
        if (i < spm) {
            P2<Integer, Node<V, A>> p = this.middle.lookup(o, i - spr);
            return p._2().lookup(o, p._1());
        }
        return this.suffix.lookup(o, i - spm);
    }

    @Override
    public int length() {
        int midSize = this.middle.foldLeft((B acc, A n) -> acc + n.length(), Integer.valueOf(0));
        return this.prefix.length() + midSize + this.suffix.length();
    }

    private static <V, A> FingerTree<V, Node<V, A>> addDigits0(Measured<V, A> m, FingerTree<V, Node<V, A>> m1, Digit<V, A> s1, Digit<V, A> p2, FingerTree<V, Node<V, A>> m2) {
        MakeTree mk = Deep.mkTree(m);
        return s1.match(one1 -> p2.match(one2 -> Deep.append1(m, m1, mk.node2(one1.value(), one2.value()), m2), two2 -> {
            V2 vs = two2.values();
            return Deep.append1(m, m1, mk.node3(one1.value(), vs._1(), vs._2()), m2);
        }, three -> {
            V3 vs = three.values();
            return Deep.append2(m, m1, mk.node2(one1.value(), vs._1()), mk.node2(vs._2(), vs._3()), m2);
        }, four -> {
            V4 vs = four.values();
            return Deep.append2(m, m1, mk.node3(one1.value(), vs._1(), vs._2()), mk.node2(vs._3(), vs._4()), m2);
        }), two1 -> {
            V2 v1 = two1.values();
            return p2.match(one -> Deep.append1(m, m1, mk.node3(v1._1(), v1._2(), one.value()), m2), two2 -> {
                V2 v2 = two2.values();
                return Deep.append2(m, m1, mk.node2(v1._1(), v1._2()), mk.node2(v2._1(), v2._2()), m2);
            }, three -> {
                V3 v2 = three.values();
                return Deep.append2(m, m1, mk.node3(v1._1(), v1._2(), v2._1()), mk.node2(v2._2(), v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append2(m, m1, mk.node3(v1._1(), v1._2(), v2._1()), mk.node3(v2._2(), v2._3(), v2._4()), m2);
            });
        }, three1 -> {
            V3 v1 = three1.values();
            return p2.match(one -> Deep.append2(m, m1, mk.node2(v1._1(), v1._2()), mk.node2(v1._3(), one.value()), m2), two -> {
                V2 v2 = two.values();
                return Deep.append2(m, m1, mk.node3(v1), mk.node2(v2), m2);
            }, three2 -> Deep.append2(m, m1, mk.node3(v1), mk.node3(three2.values()), m2), four -> Deep.append3(m, m1, mk.node3(v1), mk.node2(four.values()._1(), four.values()._2()), mk.node2(four.values()._3(), four.values()._4()), m2));
        }, four1 -> {
            V4 v1 = four1.values();
            return p2.match(one -> Deep.append2(m, m1, mk.node3(v1._1(), v1._2(), v1._3()), mk.node2(v1._4(), one.value()), m2), two -> {
                V2 v2 = two.values();
                return Deep.append2(m, m1, mk.node3(v1._1(), v1._2(), v1._3()), mk.node3(v1._4(), v2._1(), v2._2()), m2);
            }, three -> {
                V3 v2 = three.values();
                return Deep.append3(m, m1, mk.node3(v1._1(), v1._2(), v1._3()), mk.node2(v1._4(), v2._1()), mk.node2(v2._2(), v2._3()), m2);
            }, four2 -> {
                V4 v2 = four2.values();
                return Deep.append3(m, m1, mk.node3(v1._1(), v1._2(), v1._3()), mk.node3(v1._4(), v2._1(), v2._2()), mk.node2(v2._3(), v2._4()), m2);
            });
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append1(Measured<V, A> m, FingerTree<V, Node<V, A>> xs, Node<V, A> a, FingerTree<V, Node<V, A>> ys) {
        return xs.match(empty -> ys.cons(a), single -> ys.cons(a).cons((Node)single.value()), deep1 -> ys.match(empty -> xs.snoc(a), single -> xs.snoc(a).snoc((Node)single.value()), deep2 -> {
            Measured nm = m.nodeMeasured();
            return new Deep(nm, m.sum(m.sum(deep1.v, nm.measure(a)), deep2.v), deep1.prefix, Deep.addDigits1(nm, deep1.middle, deep1.suffix, a, deep2.prefix, deep2.middle), deep2.suffix);
        }));
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits1(Measured<V, Node<V, A>> m, FingerTree<V, Node<V, Node<V, A>>> m1, Digit<V, Node<V, A>> x, Node<V, A> n, Digit<V, Node<V, A>> y, FingerTree<V, Node<V, Node<V, A>>> m2) {
        MakeTree mk = Deep.mkTree(m);
        return x.match(one1 -> y.match(one2 -> Deep.append1(m, m1, mk.node3((Node)one1.value(), n, (Node)one2.value()), m2), two -> Deep.append2(m, m1, mk.node2((Node)one1.value(), n), mk.node2(two.values()), m2), three -> {
            V3 v2 = three.values();
            return Deep.append2(m, m1, mk.node3((Node)one1.value(), n, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
        }, four -> {
            V4 v2 = four.values();
            return Deep.append2(m, m1, mk.node3((Node)one1.value(), n, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
        }), two1 -> {
            V2 v1 = two1.values();
            return y.match(one -> Deep.append2(m, m1, mk.node2(v1), mk.node2(n, (Node)one.value()), m2), two -> Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n), mk.node2(two.values()), m2), three -> Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n), mk.node3(three.values()), m2), four -> {
                V4 v2 = four.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n), mk.node2((Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        }, three -> {
            V3 v1 = three.values();
            return y.match(one -> Deep.append2(m, m1, mk.node3(v1), mk.node2(n, (Node)one.value()), m2), two -> {
                V2 v2 = two.values();
                return Deep.append2(m, m1, mk.node3(v1), mk.node3(n, (Node)v2._1(), (Node)v2._2()), m2);
            }, three1 -> {
                V3 v2 = three1.values();
                return Deep.append3(m, m1, mk.node3(v1), mk.node2(n, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append3(m, m1, mk.node3(v1), mk.node3(n, (Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        }, four -> {
            V4 v1 = four.values();
            return y.match(one -> Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n, (Node)one.value()), m2), two -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node2((Node)v1._4(), n), mk.node2(two.values()), m2), three -> {
                V3 v2 = three.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four1 -> {
                V4 v2 = four1.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
            });
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append2(Measured<V, A> m, FingerTree<V, Node<V, A>> t1, Node<V, A> n1, Node<V, A> n2, FingerTree<V, Node<V, A>> t2) {
        return t1.match(empty -> t2.cons(n2).cons(n1), single -> t2.cons(n2).cons(n1).cons((Node)single.value()), deep -> t2.match(empty -> deep.snoc(n1).snoc(n2), single -> deep.snoc(n1).snoc(n2).snoc((Node)single.value()), deep2 -> new Deep(m.nodeMeasured(), m.sum(m.sum(m.sum(deep.measure(), n1.measure()), n2.measure()), deep2.measure()), deep.prefix, Deep.addDigits2(m.nodeMeasured(), deep.middle, deep.suffix, n1, n2, deep2.prefix, deep2.middle), deep2.suffix)));
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits2(Measured<V, Node<V, A>> m, FingerTree<V, Node<V, Node<V, A>>> m1, Digit<V, Node<V, A>> suffix, Node<V, A> n1, Node<V, A> n2, Digit<V, Node<V, A>> prefix, FingerTree<V, Node<V, Node<V, A>>> m2) {
        MakeTree mk = Deep.mkTree(m);
        return suffix.match(one -> prefix.match(one2 -> Deep.append2(m, m1, mk.node2((Node)one.value(), n1), mk.node2(n2, (Node)one2.value()), m2), two -> Deep.append2(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node2(two.values()), m2), three -> Deep.append2(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(three.values()), m2), four -> {
            V4 v2 = four.values();
            return Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node2((Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
        }), two -> {
            V2 v1 = two.values();
            return prefix.match(one -> Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node2(n2, (Node)one.value()), m2), two2 -> {
                V2 v2 = two2.values();
                return Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, (Node)v2._1(), (Node)v2._2()), m2);
            }, three -> {
                V3 v2 = three.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node2(n2, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, (Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        }, three -> {
            V3 v1 = three.values();
            return prefix.match(one -> Deep.append2(m, m1, mk.node3(v1), mk.node3(n1, n2, (Node)one.value()), m2), two -> Deep.append3(m, m1, mk.node3(v1), mk.node2(n1, n2), mk.node2(two.values()), m2), three2 -> {
                V3 v2 = three2.values();
                return Deep.append3(m, m1, mk.node3(v1), mk.node3(n1, n2, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append3(m, m1, mk.node3(v1), mk.node3(n1, n2, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
            });
        }, four -> {
            V4 v1 = four.values();
            return prefix.match(one -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node2((Node)v1._4(), n1), mk.node2(n2, (Node)one.value()), m2), two -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node2(two.values()), m2), three -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(three.values()), m2), four2 -> {
                V4 v2 = four2.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node2((Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append3(Measured<V, A> m, FingerTree<V, Node<V, A>> t1, Node<V, A> n1, Node<V, A> n2, Node<V, A> n3, FingerTree<V, Node<V, A>> t2) {
        Measured nm = m.nodeMeasured();
        return t1.match(empty -> t2.cons(n3).cons(n2).cons(n1), single -> t2.cons(n3).cons(n2).cons(n1).cons((Node)single.value()), deep -> t2.match(empty -> deep.snoc(n1).snoc(n2).snoc(n3), single -> deep.snoc(n1).snoc(n2).snoc(n3).snoc((Node)single.value()), deep2 -> new Deep(nm, nm.monoid().sumLeft(List.list(deep.v, n1.measure(), n2.measure(), n3.measure(), deep2.v)), deep.prefix, Deep.addDigits3(nm, deep.middle, deep.suffix, n1, n2, n3, deep2.prefix, deep2.middle), deep2.suffix)));
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits3(Measured<V, Node<V, A>> m, FingerTree<V, Node<V, Node<V, A>>> m1, Digit<V, Node<V, A>> suffix, Node<V, A> n1, Node<V, A> n2, Node<V, A> n3, Digit<V, Node<V, A>> prefix, FingerTree<V, Node<V, Node<V, A>>> m2) {
        MakeTree mk = Deep.mkTree(m);
        return suffix.match(one -> prefix.match(one2 -> Deep.append2(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node2(n3, (Node)one2.value()), m2), two -> {
            V2 v2 = two.values();
            return Deep.append2(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(n3, (Node)v2._1(), (Node)v2._2()), m2);
        }, three -> {
            V3 v2 = three.values();
            return Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node2(n3, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
        }, four -> {
            V4 v2 = four.values();
            return Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(n3, (Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
        }), two -> {
            V2 v1 = two.values();
            return prefix.match(one -> Deep.append2(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, (Node)one.value()), m2), two1 -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node2(n2, n3), mk.node2(two1.values()), m2), three -> {
                V3 v2 = three.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
            });
        }, three -> prefix.match(one -> Deep.append3(m, m1, mk.node3(three.values()), mk.node2(n1, n2), mk.node2(n3, (Node)one.value()), m2), two -> Deep.append3(m, m1, mk.node3(three.values()), mk.node3(n1, n2, n3), mk.node2(two.values()), m2), three2 -> Deep.append3(m, m1, mk.node3(three.values()), mk.node3(n1, n2, n3), mk.node3(three2.values()), m2), four -> {
            V4 v2 = four.values();
            return Deep.append4(m, m1, mk.node3(three.values()), mk.node3(n1, n2, n3), mk.node2((Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
        }), four -> {
            V4 v1 = four.values();
            return prefix.match(one -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node2(n3, (Node)one.value()), m2), two -> {
                V2 v2 = two.values();
                return Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(n3, (Node)v2._1(), (Node)v2._2()), m2);
            }, three -> {
                V3 v2 = three.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node2(n3, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four2 -> {
                V4 v2 = four2.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(n3, (Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append4(Measured<V, A> m, FingerTree<V, Node<V, A>> t1, Node<V, A> n1, Node<V, A> n2, Node<V, A> n3, Node<V, A> n4, FingerTree<V, Node<V, A>> t2) {
        Measured nm = m.nodeMeasured();
        return t1.match(empty -> t2.cons(n4).cons(n3).cons(n2).cons(n1), single -> t2.cons(n4).cons(n3).cons(n2).cons(n1).cons((Node)single.value()), deep -> t2.match(empty -> t1.snoc(n1).snoc(n2).snoc(n3).snoc(n4), single -> t1.snoc(n1).snoc(n2).snoc(n3).snoc(n4).snoc((Node)single.value()), deep2 -> new Deep(nm, m.monoid().sumLeft(List.list(deep.v, n1.measure(), n2.measure(), n3.measure(), n4.measure(), deep2.v)), deep.prefix, Deep.addDigits4(nm, deep.middle, deep.suffix, n1, n2, n3, n4, deep2.prefix, deep2.middle), deep2.suffix)));
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits4(Measured<V, Node<V, A>> m, FingerTree<V, Node<V, Node<V, A>>> m1, Digit<V, Node<V, A>> suffix, Node<V, A> n1, Node<V, A> n2, Node<V, A> n3, Node<V, A> n4, Digit<V, Node<V, A>> prefix, FingerTree<V, Node<V, Node<V, A>>> m2) {
        MakeTree mk = Deep.mkTree(m);
        return suffix.match(one -> prefix.match(one2 -> Deep.append2(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(n3, n4, (Node)one2.value()), m2), two -> Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node2(n3, n4), mk.node2(two.values()), m2), three -> {
            V3 v2 = three.values();
            return Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(n3, n4, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
        }, four -> {
            V4 v2 = four.values();
            return Deep.append3(m, m1, mk.node3((Node)one.value(), n1, n2), mk.node3(n3, n4, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
        }), two -> {
            V2 v1 = two.values();
            return prefix.match(one -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node2(n2, n3), mk.node2(n4, (Node)one.value()), m2), two2 -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, n4), mk.node2(two2.values()), m2), three -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, n4), mk.node3(three.values()), m2), four -> {
                V4 v2 = four.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), n1), mk.node3(n2, n3, n4), mk.node2((Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        }, three -> {
            V3 v1 = three.values();
            return prefix.match(one -> Deep.append3(m, m1, mk.node3(v1), mk.node3(n1, n2, n3), mk.node2(n4, (Node)one.value()), m2), two -> {
                V2 v2 = two.values();
                return Deep.append3(m, m1, mk.node3(v1), mk.node3(n1, n2, n3), mk.node3(n4, (Node)v2._1(), (Node)v2._2()), m2);
            }, three1 -> {
                V3 v2 = three1.values();
                return Deep.append4(m, m1, mk.node3(v1), mk.node3(n1, n2, n3), mk.node2(n4, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four -> {
                V4 v2 = four.values();
                return Deep.append4(m, m1, mk.node3(v1), mk.node3(n1, n2, n3), mk.node3(n4, (Node)v2._1(), (Node)v2._2()), mk.node2((Node)v2._3(), (Node)v2._4()), m2);
            });
        }, four -> {
            V4 v1 = four.values();
            return prefix.match(one -> Deep.append3(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(n3, n4, (Node)one.value()), m2), two -> Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node2(n3, n4), mk.node2(two.values()), m2), three -> {
                V3 v2 = three.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(n3, n4, (Node)v2._1()), mk.node2((Node)v2._2(), (Node)v2._3()), m2);
            }, four1 -> {
                V4 v2 = four1.values();
                return Deep.append4(m, m1, mk.node3((Node)v1._1(), (Node)v1._2(), (Node)v1._3()), mk.node3((Node)v1._4(), n1, n2), mk.node3(n3, n4, (Node)v2._1()), mk.node3((Node)v2._2(), (Node)v2._3(), (Node)v2._4()), m2);
            });
        });
    }

    public String toString() {
        return Show.fingerTreeShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    @Override
    public Stream<A> toStream() {
        return this.prefix().toStream().append(() -> this.middle().match(e -> Stream.nil(), s -> ((Node)s.value()).toStream(), d -> d.toStream().bind(p -> p.toStream()))).append(() -> this.suffix.toStream());
    }
}

