/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.data.fingertrees.FingerTree;

public final class PriorityQueue<K, A> {
    private final FingerTree<K, P2<K, A>> ftree;
    private final Equal<K> equal;

    private PriorityQueue(Equal<K> e, FingerTree<K, P2<K, A>> ft) {
        this.equal = e;
        this.ftree = ft;
    }

    public static <K, A> PriorityQueue<K, A> priorityQueue(Equal<K> e, FingerTree<K, P2<K, A>> ft) {
        return new PriorityQueue<K, A>(e, ft);
    }

    public static <K, A> PriorityQueue<K, A> empty(Monoid<K> m, Equal<K> e) {
        return PriorityQueue.priorityQueue(e, FingerTree.empty(m, P2.__1()));
    }

    public static <A> PriorityQueue<Integer, A> emptyInt() {
        return PriorityQueue.empty(Monoid.intMaxMonoid, Equal.intEqual);
    }

    public <B> PriorityQueue<K, B> map(F<A, B> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.map(P2.map2_(f), FingerTree.measured(this.ftree.measured().monoid(), P2.__1())));
    }

    public PriorityQueue<K, A> filterValues(F<A, Boolean> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.filter(p2 -> (Boolean)f.f(p2._2())));
    }

    public PriorityQueue<K, A> filterKeys(F<K, Boolean> f) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.filter(p2 -> (Boolean)f.f(p2._1())));
    }

    public boolean isEmpty() {
        return this.ftree.isEmpty();
    }

    public Option<P2<K, A>> top() {
        return this.unqueue(Option.none(), (top, tail) -> Option.some(top));
    }

    public List<P2<K, A>> topN() {
        return this.toStream().uncons(List.nil(), top -> tail -> List.cons(top, ((Stream)tail._1()).takeWhile(Function.compose(this.equal.eq(top._1()), P2.__1())).toList()));
    }

    public PriorityQueue<K, A> enqueue(K k, A a) {
        return PriorityQueue.priorityQueue(this.equal, this.ftree.snoc(P.p(k, a)));
    }

    public PriorityQueue<K, A> enqueue(List<P2<K, A>> list) {
        return list.foldLeft((pq, p) -> pq.enqueue(p._1(), p._2()), this);
    }

    public boolean contains(K k) {
        return !this.ftree.split(this.equal.eq(k))._2().isEmpty();
    }

    public PriorityQueue<K, A> enqueue(Iterable<P2<K, A>> it) {
        PriorityQueue<K, A> result = this;
        for (P2<K, A> p : it) {
            result = result.enqueue(p);
        }
        return result;
    }

    public PriorityQueue<K, A> enqueue(P2<K, A> p) {
        return this.enqueue(p._1(), p._2());
    }

    public PriorityQueue<K, A> dequeue() {
        return this.unqueue(this, (top, tail) -> tail);
    }

    public P2<Option<P2<K, A>>, PriorityQueue<K, A>> topDequeue() {
        return this.unqueue(P.p(Option.none(), this), (top, tail) -> P.p(Option.some(top), tail));
    }

    public <B> B unqueue(B empty, F2<P2<K, A>, PriorityQueue<K, A>, B> topDequeue) {
        K top = this.ftree.measure();
        P2<FingerTree<K, P2<K, A>>, FingerTree<K, P2<K, A>>> p = this.ftree.split(this.equal.eq(top));
        return (B)p._2().uncons(empty, (head, tail) -> topDequeue.f((P2<K, A>)head, PriorityQueue.priorityQueue(this.equal, ((FingerTree)p._1()).append(tail))));
    }

    public PriorityQueue<K, A> dequeue(int n) {
        int i = n;
        PriorityQueue<K, A> result = this;
        while (i > 0) {
            --i;
            result = result.dequeue();
        }
        return result;
    }

    public boolean isLessThan(Ord<K> ok, K k) {
        return this.top().option(true, p -> ok.isLessThan(p._1(), k));
    }

    public boolean isGreaterThan(Ord<K> ok, K k) {
        return this.top().option(false, p -> ok.isGreaterThan(p._1(), k));
    }

    public boolean isEqual(Ord<K> ok, K k) {
        return this.top().option(false, p -> ok.eq(p._1(), k));
    }

    public Stream<P2<K, A>> toStream() {
        return this.unqueue(Stream.nil(), (top, tail) -> Stream.cons(top, () -> tail.toStream()));
    }

    public List<P2<K, A>> toList() {
        return this.toStream().toList();
    }

    public String toString() {
        return Show.priorityQueueShow(Show.anyShow(), Show.anyShow()).showS(this);
    }
}

