/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F0;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.P;
import fj.P2;
import fj.Show;
import fj.Unit;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class Array<A>
implements Iterable<A> {
    private final Object[] a;

    private Array(Object[] a) {
        this.a = a;
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public A get(int index) {
        return (A)this.a[index];
    }

    public int hashCode() {
        return Hash.arrayHash(Hash.anyHash()).hash(this);
    }

    public Unit set(int index, A a) {
        this.a[index] = a;
        return Unit.unit();
    }

    public int length() {
        return this.a.length;
    }

    public ImmutableProjection<A> immutable() {
        return new ImmutableProjection(this);
    }

    public boolean isEmpty() {
        return this.a.length == 0;
    }

    public boolean isNotEmpty() {
        return this.a.length != 0;
    }

    public A[] array(Class<A[]> c) {
        return Array.copyOf(this.a, this.a.length, c);
    }

    public Object[] array() {
        return Array.copyOf(this.a, this.a.length);
    }

    @Deprecated
    public A[] toJavaArray() {
        return this.array();
    }

    public Option<A> toOption() {
        return this.a.length == 0 ? Option.none() : Option.some(this.a[0]);
    }

    public <X> Either<X, A> toEither(F0<X> x) {
        return this.a.length == 0 ? Either.left(x.f()) : Either.right(this.a[0]);
    }

    public List<A> toList() {
        List<Object> x = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = x.cons(this.a[i]);
        }
        return x;
    }

    public Stream<A> toStream() {
        return Stream.unfold(o -> this.a.length > o ? Option.some(P.p(this.a[o], o + 1)) : Option.none(), 0);
    }

    public String toString() {
        return Show.arrayShow(Show.anyShow()).showS(this);
    }

    public <B> Array<B> map(F<A, B> f) {
        Object[] bs = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            bs[i] = f.f(this.a[i]);
        }
        return new Array<A>(bs);
    }

    public Array<A> filter(F<A, Boolean> f) {
        List<Object> x = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            if (!f.f(this.a[i]).booleanValue()) continue;
            x = x.cons(this.a[i]);
        }
        return x.toArray();
    }

    public Unit foreach(F<A, Unit> f) {
        for (Object x : this.a) {
            f.f(x);
        }
        return Unit.unit();
    }

    public void foreachDoEffect(Effect1<A> f) {
        for (Object x : this.a) {
            f.f(x);
        }
    }

    public <B> B foldRight(F<A, F<B, B>> f, B b) {
        B x = b;
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = f.f(this.a[i]).f(x);
        }
        return x;
    }

    public <B> B foldRight(F2<A, B, B> f, B b) {
        return this.foldRight(Function.curry(f), b);
    }

    public <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B x = b;
        for (Object aa : this.a) {
            x = f.f(x).f(aa);
        }
        return x;
    }

    public <B> B foldLeft(F2<B, A, B> f, B b) {
        return this.foldLeft(Function.curry(f), b);
    }

    public <B> Array<B> scanLeft(F<B, F<A, B>> f, B b) {
        Object[] bs = new Object[this.a.length];
        B x = b;
        for (int i = 0; i < this.a.length; ++i) {
            x = f.f(x).f(this.a[i]);
            bs[i] = x;
        }
        return new Array<A>(bs);
    }

    public <B> Array<B> scanLeft(F2<B, A, B> f, B b) {
        return this.scanLeft(Function.curry(f), b);
    }

    public Array<A> scanLeft1(F<A, F<A, A>> f) {
        Object[] bs = new Object[this.a.length];
        A x = this.get(0);
        bs[0] = x;
        for (int i = 1; i < this.a.length; ++i) {
            x = f.f(x).f(this.a[i]);
            bs[i] = x;
        }
        return new Array<A>(bs);
    }

    public Array<A> scanLeft1(F2<A, A, A> f) {
        return this.scanLeft1(Function.curry(f));
    }

    public <B> Array<B> scanRight(F<A, F<B, B>> f, B b) {
        Object[] bs = new Object[this.a.length];
        B x = b;
        for (int i = this.a.length - 1; i >= 0; --i) {
            x = f.f(this.a[i]).f(x);
            bs[i] = x;
        }
        return new Array<A>(bs);
    }

    public <B> Array<B> scanRight(F2<A, B, B> f, B b) {
        return this.scanRight(Function.curry(f), b);
    }

    public Array<A> scanRight1(F<A, F<A, A>> f) {
        Object[] bs = new Object[this.a.length];
        A x = this.get(this.length() - 1);
        bs[this.length() - 1] = x;
        for (int i = this.a.length - 2; i >= 0; --i) {
            x = f.f(this.a[i]).f(x);
            bs[i] = x;
        }
        return new Array<A>(bs);
    }

    public Array<A> scanRight1(F2<A, A, A> f) {
        return this.scanRight1(Function.curry(f));
    }

    public <B> Array<B> bind(F<A, Array<B>> f) {
        List<Array<B>> x = List.nil();
        int len = 0;
        for (int i = this.a.length - 1; i >= 0; --i) {
            Array<B> bs = f.f(this.a[i]);
            len += bs.length();
            x = x.cons(bs);
        }
        final Object[] bs = new Object[len];
        x.foreach(new F<Array<B>, Unit>(){
            private int i;

            @Override
            public Unit f(Array<B> x) {
                System.arraycopy(x.a, 0, bs, this.i, x.a.length);
                this.i += x.a.length;
                return Unit.unit();
            }
        });
        return new Array<A>(bs);
    }

    public <B> Array<B> sequence(Array<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public <B, C> Array<C> bind(Array<B> sb, F<A, F<B, C>> f) {
        return sb.apply(this.map(f));
    }

    public <B, C> Array<C> bind(Array<B> sb, F2<A, B, C> f) {
        return this.bind(sb, Function.curry(f));
    }

    public <B> Array<B> apply(Array<F<A, B>> lf) {
        return lf.bind(f -> this.map((F)f));
    }

    public Array<A> reverse() {
        Object[] x = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            x[this.a.length - 1 - i] = this.a[i];
        }
        return new Array<A>(x);
    }

    public Array<A> append(Array<A> aas) {
        Object[] x = new Object[this.a.length + aas.a.length];
        System.arraycopy(this.a, 0, x, 0, this.a.length);
        System.arraycopy(aas.a, 0, x, this.a.length, aas.a.length);
        return new Array<A>(x);
    }

    public static <A> Array<A> empty() {
        return new Array<A>(new Object[0]);
    }

    @SafeVarargs
    public static <A> Array<A> array(A ... as) {
        return Array.arrayArray(as);
    }

    static <A> Array<A> mkArray(Object[] a) {
        return new Array<A>(a);
    }

    public static <A> Array<A> single(A a) {
        return new Array<A>(new Object[]{a});
    }

    public static <A> F<A[], Array<A>> wrap() {
        return Array::array;
    }

    public static <A, B> F<F<A, B>, F<Array<A>, Array<B>>> map() {
        return Function.curry((abf, array) -> array.map((F)abf));
    }

    public static <A> Array<A> join(Array<Array<A>> o) {
        F id = Function.identity();
        return o.bind(id);
    }

    public static <A> F<Array<Array<A>>, Array<A>> join() {
        return Array::join;
    }

    public boolean forall(F<A, Boolean> f) {
        for (Object x : this.a) {
            if (f.f(x).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean exists(F<A, Boolean> f) {
        for (Object x : this.a) {
            if (!f.f(x).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        return Equal.equals0(Array.class, this, o, () -> Equal.arrayEqual(Equal.anyEqual()));
    }

    public Option<A> find(F<A, Boolean> f) {
        for (Object x : this.a) {
            if (!f.f(x).booleanValue()) continue;
            return Option.some(x);
        }
        return Option.none();
    }

    public static Array<Integer> range(int from, int to) {
        if (from >= to) {
            return Array.empty();
        }
        Array<Integer> a = new Array<Integer>(new Integer[to - from]);
        for (int i = from; i < to; ++i) {
            a.set(i - from, i);
        }
        return a;
    }

    public <B, C> Array<C> zipWith(Array<B> bs, F<A, F<B, C>> f) {
        int len = Math.min(this.a.length, bs.length());
        Array<C> x = new Array<C>(new Object[len]);
        for (int i = 0; i < len; ++i) {
            x.set(i, f.f(this.get(i)).f(bs.get(i)));
        }
        return x;
    }

    public <B, C> Array<C> zipWith(Array<B> bs, F2<A, B, C> f) {
        return this.zipWith(bs, Function.curry(f));
    }

    public <B> Array<P2<A, B>> zip(Array<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public Array<P2<A, Integer>> zipIndex() {
        return this.zipWith(Array.range(0, this.length()), (A a) -> i -> P.p(a, i));
    }

    public Collection<A> toCollection() {
        return this.asJavaList();
    }

    public java.util.List<A> asJavaList() {
        return Collections.unmodifiableList(Arrays.asList(this.a));
    }

    public ArrayList<A> toJavaList() {
        return new ArrayList<A>(this.asJavaList());
    }

    public static <A> Array<A> iterableArray(Iterable<A> i) {
        return List.iterableList(i).toArray();
    }

    public static <A> Array<A> iteratorArray(Iterator<A> i) {
        return Array.iterableArray(() -> i);
    }

    @SafeVarargs
    public static <A> Array<A> arrayArray(A ... as) {
        return new Array<A>(as);
    }

    public static <A, B> P2<Array<A>, Array<B>> unzip(Array<P2<A, B>> xs) {
        int len = xs.length();
        Array<A> aa = new Array<A>(new Object[len]);
        Array<B> ab = new Array<B>(new Object[len]);
        for (int i = len - 1; i >= 0; --i) {
            P2<A, B> p = xs.get(i);
            aa.set(i, p._1());
            ab.set(i, p._2());
        }
        return P.p(aa, ab);
    }

    public static <T, U> T[] copyOf(U[] a, int len, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[len] : (Object[])java.lang.reflect.Array.newInstance(newType.getComponentType(), len);
        System.arraycopy(a, 0, copy, 0, Math.min(a.length, len));
        return copy;
    }

    public static <T> T[] copyOf(T[] a, int len) {
        return Array.copyOf(a, len, a.getClass());
    }

    public static char[] copyOfRange(char[] a, int from, int to) {
        int len = to - from;
        if (len < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        char[] copy = new char[len];
        System.arraycopy(a, from, copy, 0, Math.min(a.length - from, len));
        return copy;
    }

    public static final class ImmutableProjection<A>
    implements Iterable<A> {
        private final Array<A> a;

        private ImmutableProjection(Array<A> a) {
            this.a = a;
        }

        @Override
        public Iterator<A> iterator() {
            return this.a.iterator();
        }

        public A get(int index) {
            return this.a.get(index);
        }

        public int length() {
            return this.a.length();
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public boolean isNotEmpty() {
            return this.a.isNotEmpty();
        }

        public Option<A> toOption() {
            return this.a.toOption();
        }

        public <X> Either<X, A> toEither(F0<X> x) {
            return this.a.toEither(x);
        }

        public List<A> toList() {
            return this.a.toList();
        }

        public Stream<A> toStream() {
            return this.a.toStream();
        }

        public <B> Array<B> map(F<A, B> f) {
            return this.a.map(f);
        }

        public Array<A> filter(F<A, Boolean> f) {
            return this.a.filter(f);
        }

        public Unit foreach(F<A, Unit> f) {
            return this.a.foreach(f);
        }

        public <B> B foldRight(F<A, F<B, B>> f, B b) {
            return this.a.foldRight(f, b);
        }

        public <B> B foldLeft(F<B, F<A, B>> f, B b) {
            return this.a.foldLeft(f, b);
        }

        public <B> Array<B> bind(F<A, Array<B>> f) {
            return this.a.bind(f);
        }

        public <B> Array<B> sequence(Array<B> bs) {
            return this.a.sequence(bs);
        }

        public <B> Array<B> apply(Array<F<A, B>> lf) {
            return this.a.apply(lf);
        }

        public Array<A> reverse() {
            return this.a.reverse();
        }

        public Array<A> append(Array<A> aas) {
            return this.a.append(aas);
        }

        public Collection<A> toCollection() {
            return this.a.toCollection();
        }
    }
}

