/*
 * Decompiled with CFR 0.152.
 */
package fj.data.hamt;

import fj.F;
import fj.P2;
import fj.Show;
import fj.data.Either;
import fj.data.Stream;
import fj.data.hamt.HashArrayMappedTrie;

public final class Node<K, V> {
    private final Either<P2<K, V>, HashArrayMappedTrie<K, V>> either;

    public Node(Either<P2<K, V>, HashArrayMappedTrie<K, V>> e) {
        this.either = e;
    }

    public Node(P2<K, V> simpleNode) {
        this(Either.left(simpleNode));
    }

    public Node(HashArrayMappedTrie<K, V> hamt) {
        this(Either.right(hamt));
    }

    public static <K, V> Node<K, V> p2Node(P2<K, V> p) {
        return new Node<K, V>(p);
    }

    public static <K, V> Node<K, V> hamtNode(HashArrayMappedTrie<K, V> hamt) {
        return new Node<K, V>(hamt);
    }

    public <B> B match(F<P2<K, V>, B> f, F<HashArrayMappedTrie<K, V>, B> g) {
        return this.either.either(f, g);
    }

    public Stream<P2<K, V>> toStream() {
        return this.match(Stream::single, HashArrayMappedTrie::toStream);
    }

    public String toString() {
        return Show.hamtNodeShow(Show.anyShow(), Show.anyShow()).showS(this);
    }
}

