/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.mod.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandlerDefault;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.model.DocBorders;
import org.fugerit.java.doc.base.model.DocCell;
import org.fugerit.java.doc.base.model.DocElement;
import org.fugerit.java.doc.base.model.DocPara;
import org.fugerit.java.doc.base.model.DocRow;
import org.fugerit.java.doc.base.model.DocTable;
import org.fugerit.java.doc.base.typehelper.excel.ExcelHelperUtils;
import org.fugerit.java.doc.base.typehelper.excel.TableMatrix;
import org.fugerit.java.doc.mod.poi.PoiCellStyleModel;
import org.fugerit.java.doc.mod.poi.PoiUtils;
import org.fugerit.java.doc.mod.poi.WorkbookDataWrapper;
import org.fugerit.java.doc.mod.poi.WorkbookHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicPoiTypeHandler
extends DocTypeHandlerDefault {
    private static final Logger log = LoggerFactory.getLogger(BasicPoiTypeHandler.class);
    private static final long serialVersionUID = 1175953200917290547L;
    public static final String MODULE = "poi";

    protected BasicPoiTypeHandler(String type) {
        super(type, MODULE);
    }

    protected abstract WorkbookHelper newWorkbook(DocInput var1, InputStream var2) throws IOException;

    protected abstract void closeWorkbook(Workbook var1, DocOutput var2) throws IOException;

    protected abstract void setFormatStyle(WorkbookHelper var1, Font var2, CellStyle var3, DocCell var4, DocPara var5);

    protected abstract void setFontStyle(WorkbookHelper var1, Font var2, CellStyle var3, DocCell var4, DocPara var5);

    public static void handleDoc(DocBase docBase, OutputStream os, Workbook templateXls) throws DocException {
    }

    protected static BorderStyle getBorderWidth(int width) {
        BorderStyle b = BorderStyle.NONE;
        if (width > 5) {
            b = BorderStyle.THICK;
        } else if (width > 3) {
            b = BorderStyle.MEDIUM;
        } else if (width > 0 || width == -1) {
            b = BorderStyle.THIN;
        }
        return b;
    }

    protected void setCellValue(Workbook workbook, Cell currentCell, String type, String format, String text) throws Exception {
        try {
            if (StringUtils.isEmpty((String)type)) {
                currentCell.setCellValue(text);
            } else if ("number".equalsIgnoreCase(type)) {
                BigDecimal bd = new BigDecimal(text);
                currentCell.setCellValue(bd.doubleValue());
            } else if ("date".equalsIgnoreCase(type)) {
                String formatString = StringUtils.valueWithDefault((String)format, (String)"yyyy-MM-dd");
                if ("iso".equalsIgnoreCase(format)) {
                    formatString = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                }
                SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                Date d = sdf.parse(text);
                currentCell.setCellValue(d);
                CellStyle style = currentCell.getCellStyle();
                CreationHelper helper = workbook.getCreationHelper();
                if ("yyyy-MM-dd'T'HH:mm:ss.SSSZ".equals(formatString)) {
                    style.setDataFormat(helper.createDataFormat().getFormat("d/m/yy h:mm:ss"));
                } else if ("yyyy-MM-dd HH:mm:ss".equals(formatString)) {
                    style.setDataFormat(helper.createDataFormat().getFormat("d/m/yy h:mm:ss"));
                } else {
                    style.setDataFormat(helper.createDataFormat().getFormat("d/m/yy"));
                }
            } else {
                currentCell.setCellValue(text);
            }
        }
        catch (Exception e) {
            log.warn("Format conversion errot for text '{}', type '{}', format '{}'", new Object[]{text, type, format, e});
            currentCell.setCellValue(text);
        }
    }

    private void setFontCommonStyle(CellStyle cellStyle, DocPara currentePara, Font font) {
        if (currentePara != null) {
            if (currentePara.getStyle() == 2) {
                font.setBold(true);
            } else if (currentePara.getStyle() == 4) {
                font.setItalic(true);
            } else if (currentePara.getStyle() == 5) {
                font.setBold(true);
                font.setItalic(true);
            } else if (currentePara.getStyle() == 3) {
                font.setUnderline((byte)1);
            }
        }
        cellStyle.setFont(font);
    }

    private void setCommonBorders(CellStyle cellStyle, DocBorders borders) {
        cellStyle.setBorderBottom(BasicPoiTypeHandler.getBorderWidth(borders.getBorderWidthBottom()));
        cellStyle.setBorderTop(BasicPoiTypeHandler.getBorderWidth(borders.getBorderWidthTop()));
        cellStyle.setBorderRight(BasicPoiTypeHandler.getBorderWidth(borders.getBorderWidthRight()));
        cellStyle.setBorderLeft(BasicPoiTypeHandler.getBorderWidth(borders.getBorderWidthLeft()));
    }

    private void setCommonAlign(DocCell cell, CellStyle cellStyle) {
        if (cell != null) {
            if (cell.getAlign() == 2) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            } else if (cell.getAlign() == 3) {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (cell.getAlign() == 1) {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            }
            if (cell.getValign() == 5) {
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            } else if (cell.getValign() == 6) {
                cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
            } else if (cell.getValign() == 4) {
                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
            }
        }
    }

    private void checkFormat(WorkbookDataWrapper wrapper, Collection<PoiCellStyleModel> styleSet, DocPara currentePara, DocCell cell, int rn, int cn, Cell currentCell) throws Exception {
        TableMatrix matrix = wrapper.getTableMatrix();
        Workbook workbook = wrapper.getWorkbook();
        WorkbookHelper helper = wrapper.getWorkbookHelper();
        CellStyle cellStyle = PoiCellStyleModel.find(styleSet, currentePara, cell);
        if (cellStyle == null) {
            cellStyle = workbook.createCellStyle();
            Font font = workbook.createFont();
            this.setFontStyle(helper, font, cellStyle, cell, currentePara);
            this.setFormatStyle(helper, font, cellStyle, cell, currentePara);
            this.setFontCommonStyle(cellStyle, currentePara, font);
            DocBorders borders = matrix.getBorders(rn, cn);
            this.setCommonBorders(cellStyle, borders);
            this.setCommonAlign(cell, cellStyle);
            cellStyle.setFont(font);
            styleSet.add(new PoiCellStyleModel(cellStyle, currentePara, cell));
        }
        currentCell.setCellStyle(cellStyle);
    }

    private void iterateCellMatrix(WorkbookDataWrapper wrapper, boolean ignoreFormat, HashSet<PoiCellStyleModel> styleSet, int rn, int cn, Row currentRow) throws Exception {
        TableMatrix matrix = wrapper.getTableMatrix();
        Workbook workbook = wrapper.getWorkbook();
        String type = null;
        String format = null;
        DocCell cell = matrix.getCell(rn, cn);
        DocCell parent = matrix.getParent(rn, cn);
        String text = "";
        DocPara currentePara = null;
        if (cell != null) {
            Iterator it1 = cell.docElements();
            DocElement current = (DocElement)it1.next();
            if (current instanceof DocPara) {
                currentePara = (DocPara)current;
                text = currentePara.getText();
                type = currentePara.getType();
                format = currentePara.getFormat();
            } else {
                text = String.valueOf(current);
                currentePara = null;
            }
        } else {
            currentePara = null;
        }
        Cell currentCell = currentRow.getCell(cn);
        if (currentCell == null) {
            currentCell = currentRow.createCell(cn);
        }
        if (cell != null && parent != null && !ignoreFormat) {
            this.checkFormat(wrapper, styleSet, currentePara, cell, rn, cn, currentCell);
        }
        this.setCellValue(workbook, currentCell, type, format, text);
    }

    private void handleSubmatrix(TableMatrix matrix, boolean ignoreFormat, Sheet sheet, WorkbookHelper helper, HashSet<PoiCellStyleModel> styleSet) throws Exception {
        for (int rn = 0; rn < matrix.getRowCount(); ++rn) {
            Row currentRow = sheet.getRow(rn);
            if (currentRow == null) {
                currentRow = sheet.createRow(rn);
            }
            WorkbookDataWrapper wrapper = new WorkbookDataWrapper(matrix, helper);
            for (int cn = 0; cn < matrix.getColumnCount(); ++cn) {
                this.iterateCellMatrix(wrapper, ignoreFormat, styleSet, rn, cn, currentRow);
            }
        }
    }

    private TableMatrix handleMatrix(DocTable table, boolean ignoreFormat, Sheet sheet, WorkbookHelper helper) throws Exception {
        TableMatrix matrix = new TableMatrix(table.containerSize(), table.getColumns());
        Iterator rows = table.docElements();
        while (rows.hasNext()) {
            DocRow row = (DocRow)rows.next();
            Iterator cells = row.docElements();
            while (cells.hasNext()) {
                DocCell cell = (DocCell)cells.next();
                matrix.setNext(cell, cell.getRSpan(), cell.getCSpan());
            }
        }
        HashSet<PoiCellStyleModel> styleSet = new HashSet<PoiCellStyleModel>();
        this.handleSubmatrix(matrix, ignoreFormat, sheet, helper, styleSet);
        log.info("TOTAL STYLES : {}", (Object)styleSet.size());
        return matrix;
    }

    private void handleMerge(DocTable table, boolean ignoreFormat, Sheet sheet, WorkbookHelper helper) throws Exception {
        TableMatrix matrix = this.handleMatrix(table, ignoreFormat, sheet, helper);
        for (int rn = 0; rn < matrix.getRowCount(); ++rn) {
            for (int cn = 0; cn < matrix.getColumnCount(); ++cn) {
                DocCell cell = matrix.getCell(rn, cn);
                if (cell == null) continue;
                int rs = cell.getRSpan() - 1;
                int cs = cell.getCSpan() - 1;
                if (rs == 0 && cs == 0) continue;
                sheet.addMergedRegion(new CellRangeAddress(rn, rn + rs, cn, cn + cs));
            }
        }
    }

    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
        DocBase docBase = docInput.getDoc();
        InputStream is = ExcelHelperUtils.resoveTemplateStream((DocBase)docBase);
        boolean noTemplate = is == null;
        WorkbookHelper helper = this.newWorkbook(docInput, is);
        Workbook outputXls = helper.getWorkbook();
        String excelTableId = docBase.getInfo().getProperty("excel-table-id");
        String[] excelTableSheet = excelTableId.split(";");
        boolean ignoreFormat = "true".equalsIgnoreCase(docBase.getInfo().getProperty("excel-ignore-format"));
        for (int k = 0; k < excelTableSheet.length; ++k) {
            String[] currentSheetData = excelTableSheet[k].split("=");
            String sheetId = currentSheetData[0];
            String sheetName = currentSheetData[1];
            DocTable table = (DocTable)docBase.getElementById(sheetId);
            Sheet sheet = null;
            sheet = noTemplate ? outputXls.createSheet(sheetName) : outputXls.getSheet(sheetName);
            this.handleMerge(table, ignoreFormat, sheet, helper);
        }
        boolean tryAutoResize = BooleanUtils.isTrue((String)docBase.getInfo().getProperty("excel-try-autoresize", "false"));
        if (tryAutoResize) {
            boolean failOnAutoResizeError = BooleanUtils.isTrue((String)docBase.getInfo().getProperty("excel-fail-on-autoresize-error", "true"));
            SafeFunction.apply(() -> {
                log.info("try autoresize : {} -> {}", (Object)"excel-fail-on-autoresize-error", (Object)failOnAutoResizeError);
                PoiUtils.autoSizeColumns(outputXls);
            }, e -> PoiUtils.autoresizeFailHandler(failOnAutoResizeError));
        }
        this.closeWorkbook(outputXls, docOutput);
    }
}

