/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.mod.fop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.xml.dom.DOMUtils;
import org.fugerit.java.doc.base.config.DocCharsetProvider;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.mod.fop.FopConfig;
import org.fugerit.java.doc.mod.fop.FopConfigDefault;
import org.fugerit.java.doc.mod.fop.FreeMarkerFopTypeHandler;
import org.fugerit.java.doc.mod.fop.config.FopConfigClassLoaderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PdfFopTypeHandler
extends FreeMarkerFopTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfFopTypeHandler.class);
    public static final DocTypeHandler HANDLER = new PdfFopTypeHandler();
    public static final String ATT_FOP_CONFIG_MODE = "fop-config-mode";
    public static final String ATT_FOP_CONFIG_MODE_DEFAULT = "default";
    public static final String ATT_FOP_CONFIG_MODE_CLASS_LOADER = "classloader";
    private static final String ATT_FOP_CONFIG_MODE_CLASS_LOADER_LEGACY = "classloader-legacy";
    public static final String ATT_FOP_CONFIG_CLASSLOADER_PATH = "fop-config-classloader-path";
    public static final String ATT_FOP_CONFIG_RESOLVER_TYPE = "fop-config-resover-type";
    public static final String ATT_FOP_CONFIG_RESOLVER_TYPE_DEFAULT = FopConfigClassLoaderWrapper.DEFAULT_RESOURCE_RESOLVER.getClass().getName();
    public static final String ATT_PDF_A_MODE = "pdf-a-mode";
    public static final String ATT_PDF_A_MODE_PDF_A_1A = "PDF/A-1a";
    public static final String ATT_PDF_A_MODE_PDF_A_1B = "PDF/A-1b";
    public static final String ATT_PDF_A_MODE_PDF_A_2A = "PDF/A-2a";
    public static final String ATT_PDF_A_MODE_PDF_A_3A = "PDF/A-3a";
    public static final String ATT_PDF_UA_MODE = "pdf-ua-mode";
    public static final String ATT_PDF_UA_MODE_PDF_UA_1 = "PDF/UA-1";
    private static final String[] VALID_PDF_A = new String[]{"PDF/A-1a", "PDF/A-1b", "PDF/A-2a"};
    public static final List<String> VALID_PDF_A_MODES = Arrays.asList(VALID_PDF_A);
    private static final String[] VALID_PDF_UA = new String[]{"PDF/UA-1"};
    public static final List<String> VALID_PDF_UA_MODES = Arrays.asList(VALID_PDF_UA);
    private static final String ATT_FONT_BASE_CLASSLOADER_PATH = "font-base-classloader-path";
    public static final boolean DEFAULT_ACCESSIBILITY = true;
    public static final boolean DEFAULT_KEEP_EMPTY_TAGS = false;
    private static final long serialVersionUID = -7394516771708L;
    private boolean accessibility;
    private boolean keepEmptyTags;
    private Serializable fopConfig;
    private String pdfAMode;
    private String pdfUAMode;

    public FopConfig getFopConfig() {
        return (FopConfig)this.fopConfig;
    }

    public void setFopConfig(FopConfig fopConfig) {
        this.fopConfig = fopConfig;
    }

    public PdfFopTypeHandler(Charset charset, FopConfig fopConfig, boolean accessibility, boolean keepEmptyTags) {
        super("pdf", charset);
        this.fopConfig = fopConfig;
        this.accessibility = accessibility;
        this.keepEmptyTags = keepEmptyTags;
    }

    public PdfFopTypeHandler(Charset charset, FopConfig fopConfig) {
        this(charset, fopConfig, true, false);
    }

    public PdfFopTypeHandler(FopConfig fopConfig, boolean accessibility, boolean keepEmptyTags) {
        this(DocCharsetProvider.getDefaultProvider().resolveCharset(null), fopConfig, accessibility, keepEmptyTags);
    }

    public PdfFopTypeHandler(Charset charset, boolean accessibility, boolean keepEmptyTags) {
        this(charset, FopConfigDefault.DEFAULT, accessibility, keepEmptyTags);
    }

    public PdfFopTypeHandler(Charset charset) {
        this(charset, true, false);
    }

    public PdfFopTypeHandler(boolean accessibility, boolean keepEmptyTags) {
        this(FopConfigDefault.DEFAULT, accessibility, keepEmptyTags);
    }

    public PdfFopTypeHandler() {
        this(true, false);
    }

    @Override
    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DocOutput bufferOutput = DocOutput.newOutput((OutputStream)buffer);
        super.handle(docInput, bufferOutput);
        StreamSource xmlSource = new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer.toByteArray()), this.getCharset()));
        FopFactory fopFactory = this.getFopConfig().newFactory();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        if (StringUtils.isNotEmpty((String)this.getPdfAMode())) {
            foUserAgent.getRendererOptions().put(ATT_PDF_A_MODE, this.getPdfAMode());
        }
        if (StringUtils.isNotEmpty((String)this.getPdfUAMode())) {
            foUserAgent.getRendererOptions().put(ATT_PDF_UA_MODE, this.getPdfAMode());
        }
        foUserAgent.setAccessibility(this.isAccessibility());
        foUserAgent.setKeepEmptyTags(this.isKeepEmptyTags());
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, docOutput.getOs());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(xmlSource, res);
    }

    protected void handleConfigTag(Element config) throws ConfigException {
        String pdfAModConfig;
        super.handleConfigTag(config);
        Properties props = DOMUtils.attributesToProperties((Element)config);
        String fopConfigMode = props.getProperty(ATT_FOP_CONFIG_MODE);
        String fopConfigClassloaderPath = props.getProperty(ATT_FOP_CONFIG_CLASSLOADER_PATH);
        String fopConfigResoverType = props.getProperty(ATT_FOP_CONFIG_RESOLVER_TYPE, ATT_FOP_CONFIG_RESOLVER_TYPE_DEFAULT);
        String fontBaseClassloaderPath = props.getProperty(ATT_FONT_BASE_CLASSLOADER_PATH);
        String pdfUAModConfig = props.getProperty(ATT_PDF_UA_MODE);
        if (StringUtils.isNotEmpty((String)pdfUAModConfig)) {
            log.info("pdf ua mode -> {} : {}", (Object)ATT_PDF_UA_MODE, (Object)pdfUAModConfig);
            if (VALID_PDF_UA_MODES.contains(pdfUAModConfig)) {
                this.setPdfUAMode(pdfUAModConfig);
                this.setFormat(pdfUAModConfig);
            } else {
                throw new ConfigException("pdf-ua-mode not valid : " + pdfUAModConfig + "( valid modes are : " + VALID_PDF_A_MODES + ")");
            }
        }
        if (StringUtils.isNotEmpty((String)(pdfAModConfig = props.getProperty(ATT_PDF_A_MODE)))) {
            log.info("pdf a mode -> {} : {}", (Object)ATT_PDF_A_MODE, (Object)pdfAModConfig);
            if (VALID_PDF_A_MODES.contains(pdfAModConfig)) {
                this.setPdfAMode(pdfAModConfig);
                this.setFormat(pdfAModConfig);
            } else {
                throw new ConfigException("pdf-a-mode not valid : " + pdfAModConfig + "( valid modes are : " + VALID_PDF_A_MODES + ")");
            }
        }
        if (StringUtils.isEmpty((String)fopConfigMode) && StringUtils.isNotEmpty((String)fopConfigClassloaderPath) && StringUtils.isNotEmpty((String)fontBaseClassloaderPath)) {
            fopConfigMode = ATT_FOP_CONFIG_MODE_CLASS_LOADER_LEGACY;
            log.warn("Activated legacy ClassLoader mode. it is now deprecated : {}", (Object)ATT_FOP_CONFIG_MODE_CLASS_LOADER_LEGACY);
            throw new ConfigException("Depcreated config mode, see github fugerit-org/fj-doc repository, issue 65");
        }
        if (ATT_FOP_CONFIG_MODE_CLASS_LOADER.equalsIgnoreCase(fopConfigMode)) {
            try {
                ResourceResolver customResourceResolver = (ResourceResolver)ClassHelper.newInstance((String)fopConfigResoverType);
                FopConfigClassLoaderWrapper fopConfigClassLoaderWrapper = new FopConfigClassLoaderWrapper(fopConfigClassloaderPath, customResourceResolver);
                this.fopConfig = fopConfigClassLoaderWrapper;
            }
            catch (Exception e) {
                throw new ConfigException(PdfFopTypeHandler.class.getSimpleName() + " configuration error : " + e, (Throwable)e);
            }
        } else if (ATT_FOP_CONFIG_MODE_CLASS_LOADER_LEGACY.equalsIgnoreCase(fopConfigMode)) {
            log.warn("Activated legacy ClassLoader mode. it is now deprecated : {}", (Object)ATT_FOP_CONFIG_MODE_CLASS_LOADER_LEGACY);
            throw new ConfigException("Depcreated config mode, see github fugerit-org/fj-doc repository, issue 65");
        }
    }

    public boolean isAccessibility() {
        return this.accessibility;
    }

    public boolean isKeepEmptyTags() {
        return this.keepEmptyTags;
    }

    public String getPdfAMode() {
        return this.pdfAMode;
    }

    public void setPdfAMode(String pdfAMode) {
        this.pdfAMode = pdfAMode;
    }

    public String getPdfUAMode() {
        return this.pdfUAMode;
    }

    public void setPdfUAMode(String pdfUAMode) {
        this.pdfUAMode = pdfUAMode;
    }
}

