package org.fugerit.java.doc.base.typehelper.html;

import org.fugerit.java.doc.base.model.DocInfo;

/**
 * <p>Constants catalog for properties shared by HTML DocTypeHandler.</p>
 * 
 * <p>Basic a listing of "keys" in : &lt;info name="${key}"&gt;${value}&lt;/info&gt;</p>
 * 
 * <p>See {@link DocInfo} for document model object.</p>
 */
public class HtmlHelperConsts {

	private HtmlHelperConsts() {}
	
	/**
	 * <a href="https://venusdocs.fugerit.org/docs/html/doc_meta_info.html#html-add-to-head">See 'html-add-to-head' documentation</a>
	 */
	public static final String INFO_KEY_HTML_ADD_TO_HEAD = "html-add-to-head";
	
	/**
	 * <a href="https://venusdocs.fugerit.org/docs/html/doc_meta_info.html#html-css-link">See 'html-css-link' documentation</a>
	 */
	public static final String INFO_KEY_HTML_CSS_LINK = "html-css-link";
	
	/**
	 * <a href="https://venusdocs.fugerit.org/docs/html/doc_meta_info.html#html-css-style">See 'html-css-style' documentation</a>
	 */
	public static final String INFO_KEY_HTML_CSS_STYLE = "html-css-style";
	
	
}
